% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createRda.R
\name{createRds}
\alias{createRds}
\title{Alias for 'to.rds'}
\usage{
createRds(df, df_name = NULL, path = ".", skip_prompt = FALSE)
}
\arguments{
\item{df}{Data frame to be exported to RDS format.}

\item{df_name}{Optional; a custom file name for the saved RDS file.
If not provided, the name of the data frame variable is used.
The function adds the ".rds" extension automatically.}

\item{path}{Character string specifying the directory path where the "tmp" folder
and RDS file should be created. Defaults to the current working directory.}

\item{skip_prompt}{Logical. If TRUE, skips the confirmation prompt. If FALSE (default),
will prompt for confirmation unless the user has previously chosen to remember their preference.}
}
\value{
Invisible TRUE if successful. The function writes an RDS file to the specified path
and prints a message indicating the file's location.
}
\description{
This is a legacy alias for the 'to.rds' function to maintain compatibility with older code.
}
\examples{
\dontrun{
createRds(prl01)
}
}
