% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossling.R
\name{summarise_items}
\alias{summarise_items}
\title{Get item-by-age summary statistics}
\usage{
summarise_items(lang_items, mode = "remote")
}
\arguments{
\item{lang_items}{A dataframe as returned by \code{get_item_data()}.}

\item{mode}{A string indicating connection mode: one of \code{"local"}, or
\code{"remote"} (defaults to \code{"remote"}).}
}
\value{
A dataframe with a row for each combination of item and age, and
  columns for summary statistics for the group: number of children
  (\code{n_children}), means (\code{comprehension}, \code{production}),
  standard deviations (\code{comprehension_sd}, \code{production_sd}); also
  retains item-level variables from \code{lang_items} (\code{item_id},
  \code{definition}, \code{uni_lemma}, \code{lexical_category},
  \code{lexical_class}).
}
\description{
Get item-by-age summary statistics
}
\examples{
\dontrun{
italian_dog <- get_item_data(language = "Italian", form = "WG") \%>\%
  dplyr::filter(uni_lemma == "dog")
italian_dog_summary <- summarise_items(italian_dog)
}
}
