% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-wp-tags.R
\name{create_wp_tags}
\alias{create_wp_tags}
\title{Create a New WordPress Tag}
\usage{
create_wp_tags(root_url, user, pass, tag_name, description_text)
}
\arguments{
\item{root_url}{The domain on which you wish to create the post.}

\item{user}{The username to be passed into the API call to create the post.}

\item{pass}{The password to be used in the API call to create the post. To get this value, you
must have the Application Passwords plugin
installed, and must create an application using that plugin via your WordPress admin panel;
there you will get the password needed.}

\item{tag_name}{The text string associated with the tag.}

\item{description_text}{The description of the tag; this value will be used wherever the
description of the WordPress tag is used (perhaps in your theme).}
}
\value{
response from the API. 200 means the tag was created!
}
\description{
Create a tag on your WordPress site using your WordPress site's API.
}
\examples{
\dontrun{
create_wp_tag(root_url = 'https://domain.com',user = Sys.getenv('username'),
pass = Sys.getenv('password'),
tag_name = 'cool posts',description_text = 'this is the description text for the tag "cool
posts". ')
}

}
