% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{wb_income_level}
\alias{wb_income_level}
\title{World Bank income level data}
\source{
\url{https://api.worldbank.org/v2/incomeLevels}
}
\usage{
wb_income_level(income = NULL, lang = "en")
}
\arguments{
\item{income}{(\code{NULL} | \code{character()})\cr
Income level to query. Default \code{NULL}. If \code{NULL}, all levels are returned.}

\item{lang}{(\code{character(1)})\cr
Language to query. Default \code{"en"}.}
}
\value{
A \code{data.frame()} with the available income levels. The columns are:
\item{id}{The income level ID.}
\item{iso2code}{The ISO 2 code of the income level.}
\item{value}{The income level value.}
}
\description{
List all income levels supported by the World Bank API.
}
\examples{
\dontshow{if (httr2::is_online()) withAutoprint(\{ # examplesIf}
wb_income_level()
\dontshow{\}) # examplesIf}
}
\seealso{
Other indicators data: 
\code{\link{wb_country}()},
\code{\link{wb_indicator}()},
\code{\link{wb_language}()},
\code{\link{wb_lending_type}()},
\code{\link{wb_region}()},
\code{\link{wb_source}()},
\code{\link{wb_topic}()}
}
\concept{indicators data}
