% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtSizeUniq.R
\name{filtSizeUniq}
\alias{filtSizeUniq}
\title{Filter for unique elements}
\usage{
filtSizeUniq(x, ref = NULL, minSize = 5, maxSize = 36,
  filtUnique = TRUE, silent = TRUE, callFrom = NULL)
}
\arguments{
\item{x}{list of character-vectors or character-vector}

\item{ref}{(character) if not NULL used as alternative 'reference' for considering elements of 'x' as unique}

\item{minSize}{(integer) minimum number of characters}

\item{maxSize}{(integer) maximum number of characters}

\item{filtUnique}{(logical) if TRUE return unique-only strings, if FALSE return only repeated strings}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
list of filtered input
}
\description{
This function aims to identify and remove duplicated elements in list and maintaining the list-structure in the output. 
\code{filtSizeUniq}  filters 'x' (list of character-vectors or character-vector) for elements being unique (to 'ref' or if NULL to all 'x') and of character length. 
Note : This functions is fairly slow with long lists !!
}
\examples{
filtSizeUniq(list(A="a",B=c("b","bb","c"),D=c("dd","d","ddd","c")),filtUn=TRUE,minSi=NULL)
# input: c and dd are repeated
filtSizeUniq(list(A="a",B=c("b","bb","c"),D=c("dd","d","ddd","c")),ref=c(letters[c(1:26,1:3)],
  "dd","dd","bb","ddd"),filtUn=TRUE,minSi=NULL)  # a,b,c,dd repeated 
}
\seealso{
\code{\link{correctToUnique}}, \code{\link[base]{unique}}, \code{\link[base]{duplicated}}
}
