% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stableMode.R
\name{stableMode}
\alias{stableMode}
\title{Estimate mode (most frequent value)}
\usage{
stableMode(
  x,
  method = "density",
  finiteOnly = TRUE,
  bandw = NULL,
  rangeSign = 1:6,
  nCl = NULL,
  histLike = NULL,
  silent = FALSE,
  callFrom = NULL,
  debug = FALSE
)
}
\arguments{
\item{x}{(numeric, or character if 'method='mode') data to find/estimate most frequent value}

\item{method}{(character) There are 3 options : BBmisc, binning and density (default). If "binning" the function will search context dependent, ie like most frequent class of histogram.
Using "binning" mode the search will be refined if either 80 percent of values in single class or >50 percent in single class.}

\item{finiteOnly}{(logical) suppress non-finite values; allows avoiding \code{NULL} as result in presence of some \code{Inf} values; \code{NA} will be ignored in any case}

\item{bandw}{(integer) only used when \code{method="binning"} or  \code{method="density"} : defines the number of points to look for density or number of classes used; 
very "critical" parameter, may change results in strong way. Note: with \code{method="binning"}: At higher values for "bandw" you will finally loose advantage of histLike-type search of mode !}

\item{rangeSign}{(integer) only used when \code{method="binning"}: range of numbers used as number of significant values}

\item{nCl}{(integer) depreciated argument, please use \code{bandw} instead}

\item{histLike}{(logical) depreciated, please use argument \code{method} instead}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allows easier tracking of messages produced}

\item{debug}{(logical) additional messages for debugging}
}
\value{
This function returns a numeric vector with value of mode, the name of the value indicates it's position
}
\description{
Estimate mode, ie most frequent value. In case of continuous numeric data, the most frequent values may not be the most frequently repeated exact term.
This function offers various approches to estimate the mode of a numeric vector. 
Besides, it can also be used to identify the most frequentexact term (in this case also from character vectors).
}
\details{
The argument \code{method} allows to choose among (so far) 4 different methods available.
If "density" is chosen, the most dense region of sqrt(n) values will be chosen; 
if "binning", the data will be binned (like in histograms) via rounding to a user-defined number of significant values ("rangeSign").
If \code{method} is set to "BBmisc", the function \code{computeMode()} from package \href{https://CRAN.R-project.org/package=BBmisc}{BBmisc} will be used.
If "mode" is chosen, the first most frequently occuring (exact) value will be returned, if "allModes", all ties will be returned. This last mode also works with character input.
}
\examples{
set.seed(2012); dat <- round(c(rnorm(50), runif(100)),3)
stableMode(dat)
}
\seealso{
\code{computeMode()} in package \href{https://CRAN.R-project.org/package=BBmisc}{BBmisc}
}
