% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizeAsListOfRepl.R
\name{organizeAsListOfRepl}
\alias{organizeAsListOfRepl}
\title{(re)organize data of (3-dim) array as list of replicates}
\usage{
organizeAsListOfRepl(
  arrIn,
  inspNChar = 0,
  byDim = 3,
  silent = TRUE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{arrIn}{(array) main input}

\item{inspNChar}{(interger) if inspNChar=0 the array-names (2nd dim of 'arrIn') will be cut before last '_'}

\item{byDim}{(integer, length=1) dimension number along which data will be split in separate elements (considering the first inspNChar characters)}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a list of arrays (typically 1st and 2nd dim for specific genes/objects, 3rd for different measures associated with)
}
\description{
Organize array of all data ('arrIn', long table) into list of (replicate-)arrays (of similar type/layout) based on dimension number 'byDim' of 'arrIn' (eg 2nd or 3rd dim).
Argument \code{inspNChar} defines the number of characters to consider, so if the beginning of names is the same they will be separated as list of multiple arrays.
Default will search for '_' separator or trim from end if not found in the relevant dimnames
}
\examples{
arr1 <- array(1:24,dim=c(4,3,2),dimnames=list(c(LETTERS[1:4]),
  paste("col",1:3,sep=""), c("ch1","ch2")))
organizeAsListOfRepl(arr1)
}
\seealso{
\code{\link[base]{array}}
}
