% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unpack.R
\name{unpack}
\alias{unpack}
\title{Unpack or bind values by names into the calling environment.}
\usage{
unpack(wrapr_private_value, ...)
}
\arguments{
\item{wrapr_private_value}{list of values to copy}

\item{...}{argument names to write to}
}
\value{
value passed in (invisible)
}
\description{
Unpacks or binds values into the calling environment. Uses \code{bquote} escaping.
NULL is a special case that is unpacked to all targets. NA targets are skipped.
All non-NA target names must be unique.
}
\details{
Note: a reference to the unpacker object is written into the unpacking environment as a side-effect
of the implied array assignment.
Array-assign form can not use the names: \code{.}, \code{wrapr_private_self}, \code{value}, or \code{unpack}.
Function form can not use the names: \code{.} or \code{wrapr_private_value}.
For more details please see here \url{http://www.win-vector.com/blog/2020/01/unpack-your-values-in-r/}.

Related work includes \code{Python} tuple unpacking, \code{zeallot}'s arrow, and \code{vadr::bind}.
}
\examples{

# named unpacking
# looks like assignment: DESTINATION = NAME_VALUE_USING
d <- data.frame(x = 1:2,
                g=c('test', 'train'),
                stringsAsFactors = FALSE)
unpack[train_set = train, test_set = test] <- split(d, d$g)
# train_set and test_set now correctly split
print(train_set)
print(test_set)
rm(list = c('train_set', 'test_set'))

# named unpacking NEWNAME = OLDNAME implicit form
# values are matched by name, not index
unpack[train, test] <- split(d, d$g)
print(train)
print(test)
rm(list = c('train', 'test'))

# function version
unpack(split(d, d$g), train, test)
print(train)
print(test)
rm(list = c('train', 'test'))

# pipe version
split(d, d$g) \%.>\% unpack(., train, test)
print(train)
print(test)
rm(list = c('train', 'test'))
# Note: above is wrapr dot-pipe, piping does not currently work with
# magrittr pipe due to magrittr's introduction of temporary
# intermediate environments during evaluation.

}
