% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask_x3p.R
\name{x3p_add_annotation}
\alias{x3p_add_annotation}
\title{Add annotations to an x3p object}
\usage{
x3p_add_annotation(x3p, color, annotation)
}
\arguments{
\item{x3p}{x3p object}

\item{color}{name or hex value of color}

\item{annotation}{character value describing the region}
}
\value{
x3p object with the added annotations
}
\description{
Annotations in an x3p object are  legend entries for each color of a mask.
}
\examples{
\dontrun{
logo <- x3p_read(system.file("csafe-logo.x3p", package="x3ptools"))
color_logo <- png::readPNG(system.file("csafe-color.png", package="x3ptools"))
logoplus <- x3p_add_mask(logo, as.raster(color_logo))
x3p_image(logoplus, multiply=50, size = c(741, 419),zoom = 0.5)
logoplus <- x3p_add_annotation(logoplus, "#FFFFFFFF", "background")
logoplus <- x3p_add_annotation(logoplus, "#818285FF", "text")
logoplus <- x3p_add_annotation(logoplus, "#F6BD47FF", "fingerprint")
logoplus <- x3p_add_annotation(logoplus, "#D2202FFF", "fingerprint")
logoplus <- x3p_add_annotation(logoplus, "#92278FFF", "fingerprint")

x3p_add_legend(logoplus)
}
}
