% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcEAD.R
\name{calcEAD}
\alias{calcEAD}
\title{Calculates the Exposure-At-Default (EAD)}
\usage{
calcEAD(trades, framework, col, EEE, time_points)
}
\arguments{
\item{trades}{The full list of the Trade Objects}

\item{framework}{Specifies the regulatory framework used in the calculations. It can take the values of 'IMM', 'CEM', 'SA-CCR'}

\item{col}{The margin agreement with the counterparty}

\item{EEE}{A vector containing the effective expected exposure against the counterparty}

\item{time_points}{The timepoints that the analysis is performed on}
}
\value{
The Exposure-At-Default
}
\description{
Calculates the Exposure-At-Default (EAD) based on the given regulatory framework. It supports the CEM, SA-CCR and IMM frameworks
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}

