/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.BoolEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;

public abstract class LogicalFunction
implements Function {
    public static final Function IsLogical = new LogicalFunction(){

        protected boolean evaluate(ValueEval arg) {
            return arg instanceof BoolEval;
        }
    };
    public static final Function IsNonText = new LogicalFunction(){

        protected boolean evaluate(ValueEval arg) {
            return !(arg instanceof StringEval);
        }
    };
    public static final Function IsNumber = new LogicalFunction(){

        protected boolean evaluate(ValueEval arg) {
            return arg instanceof NumberEval;
        }
    };
    public static final Function IsText = new LogicalFunction(){

        protected boolean evaluate(ValueEval arg) {
            return arg instanceof StringEval;
        }
    };

    private static ValueEval xlateRefEval(RefEval reval) {
        ValueEval retval = reval.getInnerValueEval();
        if (retval instanceof RefEval) {
            RefEval re = (RefEval)retval;
            retval = LogicalFunction.xlateRefEval(re);
        }
        return retval;
    }

    public final ValueEval evaluate(ValueEval[] operands, int srcCellRow, short srcCellCol) {
        ValueEval ve;
        if (operands.length != 1) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            ve = OperandResolver.getSingleValue(operands[0], srcCellRow, srcCellCol);
        }
        catch (EvaluationException e) {
            ve = e.getErrorEval();
        }
        if (ve instanceof RefEval) {
            ve = LogicalFunction.xlateRefEval((RefEval)ve);
        }
        return BoolEval.valueOf(this.evaluate(ve));
    }

    protected abstract boolean evaluate(ValueEval var1);
}

