% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_string_addin.R
\name{wrapStringAddin}
\alias{wrapStringAddin}
\title{Wraps the selection with paste0}
\usage{
wrapStringAddin(
  selection = NULL,
  indentation = 0,
  every_n = NULL,
  tolerance = 10,
  insert = TRUE
)
}
\arguments{
\item{selection}{String of code. (Character)

\strong{N.B.} Mainly intended for testing the addin programmatically.}

\item{indentation}{Indentation of the selection. (Numeric)

\strong{N.B.} Mainly intended for testing the addin programmatically.}

\item{every_n}{Number of characters per split.

If NULL, the following is used to calculate the string width:

\code{max(min(80 - indentation, 70), 50)}

\strong{N.B.} Strings shorter than \code{every_n + tolerance} will not be wrapped.}

\item{tolerance}{Tolerance. Number of characters.

We may prefer not to split a string that's only a few
characters too long. Strings shorter than \code{every_n + tolerance}
will not be wrapped.}

\item{insert}{Whether to insert the wrapped text via
\code{\link[rstudioapi:insertText]{rstudioapi::insertText()}}
or return it. (Logical)

\strong{N.B.} Mainly intended for testing the addin programmatically.}
}
\value{
Inserts the following (with newlines and correct indentation):

\code{paste0("first n chars", "next n chars")}

Returns \code{NULL} invisibly.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Splits the selection every n characters
and inserts it in a \code{\link[base:paste0]{paste0()}} call.

See \code{Details} for how to set a key command.
}
\details{
\subsection{How to set up a key command in RStudio}{

After installing the package.
Go to:

\code{Tools >> Addins >> Browse Addins >> Keyboard Shortcuts}.

Find \code{"Wrap String with paste0"} and press its
field under \code{Shortcut}.

Press desired key command, e.g. \code{Alt+P}.

Press \code{Apply}.

Press \code{Execute}.
}
}
\seealso{
Other addins: 
\code{\link{assertCollectionAddin}()},
\code{\link{dputSelectedAddin}()},
\code{\link{initializeGXSFunctionAddin}()},
\code{\link{initializeTestthatAddin}()},
\code{\link{insertExpectationsAddin}()},
\code{\link{navigateTestFileAddin}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{addins}
