% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suppress_mw.R
\name{suppress_mw}
\alias{suppress_mw}
\title{Suppress warnings and messages}
\usage{
suppress_mw(expr)
}
\arguments{
\item{expr}{Any expression to run within \code{\link[base:message]{suppressMessages()}} and
\code{\link[base:warning]{suppressWarnings()}}.}
}
\value{
The output of \code{expr}.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Run expression wrapped in both
\code{\link[base:message]{suppressMessages()}} and
\code{\link[base:warning]{suppressWarnings()}}.
}
\details{
\code{suppressWarnings(suppressMessages(expr))}
}
\examples{
# Attach packages
library(xpectr)

fn <- function(a, b){
  warning("a warning")
  message("a message")
  a + b
}

suppress_mw(fn(1, 5))
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
