% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xset_waterfall.R
\name{xset_waterfall}
\alias{xset_waterfall}
\title{Waterfall plot}
\usage{
xset_waterfall(
  xpdb_s,
  ...,
  .inorder = FALSE,
  type = "bh",
  .cols = NULL,
  max_nind = 0.7,
  scale_diff = TRUE,
  show_n = TRUE,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  tag = NULL,
  plot_name = "waterfall",
  opt,
  facets = NULL,
  facet_scales = "free_x",
  .problem,
  .subprob,
  .method,
  quiet
)
}
\arguments{
\item{xpdb_s}{<\code{xpose_set}> object}

\item{...}{See <\code{\link{two_set_dots}}>}

\item{.inorder}{See <\code{\link{two_set_dots}}>}

\item{type}{See Details.}

\item{.cols}{<\code{tidyselect}> data columns to plot.}

\item{max_nind}{If less than 1, the percentile of absolute
change values above which to plot.
If above 1, the absolute number of subjects is included. To show all,
use an extreme positive number like 9999.}

\item{scale_diff}{<\code{logical}> Scale change to the standard deviation
of the model 1 column values. Respects faceting.}

\item{show_n}{<\code{logical}> For faceting variables, show N per facet.
\emph{Not implemented}}

\item{title}{Plot title}

\item{subtitle}{Plot subtitle}

\item{caption}{Plot caption}

\item{tag}{Plot tag}

\item{plot_name}{Metadata name of plot}

\item{opt}{User-specified data options. Only some of these
will be used.}

\item{facets}{<\code{character}> Faceting variables}

\item{facet_scales}{<\code{character}> Forwarded to \code{facet_*(scales = facet_scales)}}

\item{.problem}{The problem to be used, by default returns the last one.}

\item{.subprob}{The subproblem to be used, by default returns the last one.}

\item{.method}{The estimation method to be used, by default returns the last one.}

\item{quiet}{Silence extra debugging output}
}
\value{
The desired plot
}
\description{
Generic function primarily used with wrappers targeting
types of values changed between two models.
}
\details{
For type-based customization of plots:
\itemize{
\item \code{b} bar plot (from \code{geom_bar})
\item \code{h} hline at 0 (from \code{geom_hline})
\item \code{t} text of change value (from \code{geom_text})
}
}
