% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xp_xtras.R
\name{set_var_levels}
\alias{set_var_levels}
\title{Set variable levels}
\usage{
set_var_levels(
  xpdb,
  .problem = NULL,
  ...,
  .missing = "Other",
  .handle_missing = c("quiet", "warn", "error")
)
}
\arguments{
\item{xpdb}{<\code{xp_xtras}> object}

\item{.problem}{<\code{numeric}> Problem number to use. Uses the all problems if \code{NULL}}

\item{...}{<\code{list}> of formulas or leveler functions, where the relevant variable is provided as the argument,}

\item{.missing}{<\code{character}> Value to use for missing levels}

\item{.handle_missing}{<\code{character}> How to handle missing levels: "quiet", "warn", or "error"}
}
\value{
<\code{xp_xtras}> object with updated levels
}
\description{
For variable types such as \code{catcov}, it can be convenient to define
levels. This function provides a straightforward means to do so,
consistent with \code{tidy} functions like <\code{\link[dplyr:case_when]{case_when}}>.

Several convenience functions are provided for common levels in <\code{\link[=as_leveler]{levelers}}>.
}
\examples{

set_var_levels(xpdb_x,
  SEX = lvl_sex(),
  MED1 = lvl_bin(),
  MED2 = c(
    0 ~ "n",
    1 ~ "y"
  )
)

}
