% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module1_irt_utils.R
\name{irt_model}
\alias{irt_model}
\alias{plot.model.3pl}
\alias{print.irt.model}
\title{Create IRT Models}
\usage{
irt_model(model = c("3pl"), people = NULL, items = NULL,
  responses = NULL, ...)

\method{print}{irt.model}(x, ...)

\method{plot}{model.3pl}(x, ...)
}
\arguments{
\item{model}{the name of IRT model}

\item{people}{a data frame of people parameters}

\item{items}{a data frame of item parameters}

\item{responses}{a data frame of responses}

\item{...}{other arguments passed to the constructor}

\item{x}{a \code{irt_model} object}
}
\description{
Create a IRT model object via a common interface
}
\details{
In \code{plot_irt_model}, use the \code{stats} argument to control what IRT statistics to draw.
Use \code{total} argument to control whether aggregate results over items/people or not.
}
\examples{
# create a 3PL model with given parameters
x <- model_3pl()$gendata(10, 5)
irt_model("3pl", x$people, x$items, x$responses)
# create a 3PL model with generated data
irt_model("3pl")$gendata(10, 5)
# generate data with Rasch items
irt_model("3pl")$gendata(10, 5, a.sd=0, c.alpha=0)
# draw test/item characteristic curve
x <- irt_model("3pl")$gendata(20, 5)
plot(x, stats="prob")
plot(x, stats="prob", total=FALSE)
# draw test/iten information function
plot(x, stats="info")
plot(x, stats="info", total=FALSE)
# draw loglikelihood
plot(x, stats="loglik")
plot(x, stats="loglik", total=FALSE, theta=seq(-5, 5, .1))
}

