% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolve.R
\name{resolve.dvec}
\alias{resolve.dvec}
\title{Resolve Guide for Decorated Vector}
\usage{
\method{resolve}{dvec}(x, ...)
}
\arguments{
\item{x}{dvec}

\item{...}{passed to \code{\link{explicit_guide}}, \code{\link{classified}}, and \code{\link{make_title}}}
}
\value{
dvec or classified
}
\description{
Resolves implicit usage of default key 'guide' to
explicit usage for class dvec.
Simply calls \code{\link{explicit_guide}}
followed by \code{\link{classified}} if x has a codelist attribute.
If option \code{yamlet_with_title} is not NULL, and if 'units'
present, label and units will be concatenated by default to create
a title attribute.
}
\examples{
library(magrittr)
x <- as_dvec(1:3, guide = list(a = 1, b = 2, c = 3))
x \%>\% str
x \%>\% classified \%>\% str
x \%>\% explicit_guide \%>\% classified \%>\% str
x \%>\% resolve \%>\% str
}
\seealso{
Other resolve: 
\code{\link{desolve}()},
\code{\link{desolve.classified}()},
\code{\link{desolve.data.frame}()},
\code{\link{desolve.decorated}()},
\code{\link{desolve.dvec}()},
\code{\link{resolve}()},
\code{\link{resolve.classified}()},
\code{\link{resolve.data.frame}()},
\code{\link{resolve.decorated}()}

Other dvec: 
\code{\link{[.dvec}()},
\code{\link{[<-.dvec}()},
\code{\link{[[.dvec}()},
\code{\link{[[<-.dvec}()},
\code{\link{as.data.frame.dvec}()},
\code{\link{as_dvec}()},
\code{\link{as_dvec.character}()},
\code{\link{as_dvec.complex}()},
\code{\link{as_dvec.dvec}()},
\code{\link{as_dvec.integer}()},
\code{\link{as_dvec.logical}()},
\code{\link{as_dvec.numeric}()},
\code{\link{c.dvec}()},
\code{\link{classified.dvec}()},
\code{\link{desolve.dvec}()},
\code{\link{explicit_guide.data.frame}()},
\code{\link{format.dvec}()},
\code{\link{implicit_guide.dvec}()},
\code{\link{length.dvec}()},
\code{\link{print.dvec}()},
\code{\link{resolve.classified}()},
\code{\link{unclassified.dvec}()}
}
\concept{dvec}
\concept{resolve}
\keyword{internal}
