% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec_classified.R
\name{vec_ptype2.classified.classified}
\alias{vec_ptype2.classified.classified}
\title{Find Common Type for classified, classified}
\usage{
\method{vec_ptype2}{classified.classified}(x, y, ...)
}
\arguments{
\item{x}{classified}

\item{y}{classified}

\item{...}{ignored}
}
\description{
Find common type for classified, classified.
}
\examples{
library(vctrs)
library(magrittr)
c1 <- classified('a', levels = c('a','b')) \%>\% structure(label = 'c1')
c2 <- classified('b', levels = c('a','b')) \%>\% structure(label = 'c2')
c3 <- classified('c', levels = c('a','c')) \%>\% structure(label = 'c3')
f1 <- factor('a', levels = c('a','b')) \%>\% structure(label = 'f1')
f2 <- factor('b', levels = c('a','b')) \%>\% structure(label = 'f2')
f3 <- factor('c', levels = c('a','c')) \%>\% structure(label = 'f3')

vec_c(c1, c1) # combined data, same codelist
vec_c(c1, c2) # combined data, same codelist
vec_c(c2, c1) # reversed data, same codelist

vec_c(c1, c3) # combined data, combined codelist
vec_c(c3, c1) # reversed data, revised codelist
vec_c(c1, f1) # matching levels: return classified
vec_c(f1, c1) # matching levels: return classified

vec_c(c1, f2) # matching levels: return classified
vec_c(f2, c1) # matching levels: return classified

vec_c(c1, f3) # mismatched levels: return factor
vec_c(f3, c1) # mismatched levels: return factor
}
\keyword{internal}
