% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print}
\alias{print}
\alias{print.rmd_doc}
\title{Print Method for rmd_doc}
\usage{
\method{print}{rmd_doc}(x, maxlines = 15, ...)
}
\arguments{
\item{x}{An object of class \code{rmd_doc}.}

\item{maxlines}{An integer value indicating the number of lines used for the
display. Longer documents will be truncated.}

\item{...}{Further arguments passed among methods (not yet in use).}
}
\value{
A display of the resulting R-Markdown document in the console.
}
\description{
Quick display for \code{rmd_doc} objects. This method also defines the way how
objects are displayed in the console.
}
\examples{

## Create a new document
my_document <- write_rmd(
		title = "A journey in rOpenSci",
		author = "Miguel Alvarez",
		output = "html_document",
		body = read_rmd(file.path(path.package("yamlme"),
						"taxlistjourney.Rmd")))
my_document

\dontrun{
## Render the document
render_rmd(my_document, "taxlistjourney")
}

}
