% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zi_validate.R
\name{zi_repair}
\alias{zi_repair}
\title{Repair ZIP Code or ZCTA Vector}
\usage{
zi_repair(x, style = "zcta5")
}
\arguments{
\item{x}{A vector containing ZIP or ZCTA values to be repaired.}

\item{style}{A character scalar - either \code{"zcta5"} or \code{"zcta3"}.}
}
\value{
A repaired vector of ZIP or ZCTA values.
}
\description{
This function repairs two of the four conditions identified
    in the validation checks with \code{zi_validate()}. For the other two
    conditions, values are conveted \code{NA}. See Details below for the
    specific changes made.
}
\details{
The \code{zi_repair()} function addresses four conditions:
\itemize{
 \item{If the input vector is numeric, it will be converted to character data.}
 \item{If there are values less than five characters (if \code{style = "zcta5"},
     the default), or three characters (if \code{style = "zcta3"}), they will
     be padded with leading zeros.}
 \item{If there are input values over five characters (if \code{style = "zcta5"},
     the default), or three characters (if \code{style = "zcta3"}), they will
     be converted to \code{NA}.}
 \item{If there are input values that have non-numeric characters, they will
     be converted to \code{NA}.}
}

Since two of the four steps will result in \code{NA} values, it is strongly
recommended to attempt to manually fix these issues first.
}
\examples{
# sample five-digit ZIPs with character
zips <- c("63088", "63108", "zip")

# failed validation
zi_validate(zips)

# repair
zips <- zi_repair(zips)

# successful validation
zi_validate(zips)

}
