% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh.R
\name{compute_mh_p_ssrs_sum}
\alias{compute_mh_p_ssrs_sum}
\title{Compute "Short Social Responsiveness Scale [Parent]: Sum"}
\usage{
compute_mh_p_ssrs_sum(
  data,
  name = "mh_p_ssrs_sum",
  max_na = 0,
  exclude = NULL,
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. Name of the summary score column.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed. \code{NULL} means no limit.}

\item{exclude}{character vector. Values to be excluded from the summary
score calculation.}

\item{combine}{logical. If \code{TRUE} (default), the summary score is
is appended as a new column to the input data frame. If \code{FALSE}, the
summary score is returned as a separate one-column data frame.}
}
\value{
tbl. see \code{combine}.
}
\description{
Computes the summary score \code{mh_p_ssrs_sum}
Short Social Responsiveness Scale [Parent]: Sum
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_p_ssrs_001}
\item \code{mh_p_ssrs_002}
\item \code{mh_p_ssrs_003}
\item \code{mh_p_ssrs_004}
\item \code{mh_p_ssrs_005}
\item \code{mh_p_ssrs_006}
\item \code{mh_p_ssrs_007}
\item \code{mh_p_ssrs_008}
\item \code{mh_p_ssrs_009}
\item \code{mh_p_ssrs_010}
\item \code{mh_p_ssrs_011}
}
\item \emph{Excluded values:} none
\item \emph{Validation criterion:} none of 11 items missing
}
}
\examples{
\dontrun{
compute_mh_p_ssrs_sum(data) |>
  select(
    any_of(c("mh_p_ssrs_sum", vars_mh_p_ssrs))
  )
}
}
\seealso{
\code{\link[=compute_mh_p_ssrs_nm]{compute_mh_p_ssrs_nm()}}
}
