% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hodges.ajne.R
\name{hodges.ajne}
\alias{hodges.ajne}
\title{Perform Hodges-Ajne test}
\usage{
hodges.ajne(x, alternative = c("two.sided"), minx = 0, maxx = 360)
}
\arguments{
\item{x}{Numeric vector}

\item{alternative}{Type of alternative hypothesis (defaults to \code{c("two.sided")})}

\item{minx}{Minimum value for x (defaults to \code{0})}

\item{maxx}{Maximum value for x (defaults to \code{360})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{hodges.ajne()} performs the Hodges-Ajne test and is used in chapter 4 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 4.16 from "Applied Nonparametric Statistical Methods" (5th edition)
hodges.ajne(ch4$times.as.degrees)

# Exercise 4.14 from "Applied Nonparametric Statistical Methods" (5th edition)
hodges.ajne(ch4$board.angles)

}
