% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_social_disorder.R
\name{calc_social_disorder}
\alias{calc_social_disorder}
\title{Calculate Neighborhood Social Disorder Score}
\usage{
calc_social_disorder(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer_concept_id`.}
}
\value{
A data frame with two columns: `person_id` and `social_disorder`, where `social_disorder` is the average score for neighborhood social disorder
for each participant. The score is calculated as the mean of seven items, with higher values indicating more social disorder.
Participants who did not answer all seven questions will have NA values.
}
\description{
This function computes a numeric score representing the level of social disorder in a participant's neighborhood.
The score ranges from 1 to 4, with higher scores indicating higher social disorder and lower scores indicating social order.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = rep(1:3, each = 7),
  question_concept_id = rep(c(40192500, 40192493, 40192457, 40192476,
                              40192404, 40192400, 40192384), times = 3),
  answer_concept_id = sample(c(40192514, 40192455, 40192408, 40192422),
                             21, replace = TRUE)
)

# Compute neighborhood social disorder scores
social_disorder_scores <- calc_social_disorder(survey_df)
head(social_disorder_scores)

}
