# test data, three cluster lists. c1 and c2 overlap while c3 is far away
# every single cluster is made with try_place = FALSE
# these are legacy clusterlists without clonotypes

c1 <- list(x = c(-1.3, 1.3, -1.48029736616688e-16, -1.97727239868245,
                 -0.728260708834882, 1.24901168984757, 2.54351675296717, 2.22044604925031e-16,
                 3.58851376253731), y = c(0.632455532033676, 0.632455532033676,
                                          -1.26491106406735, -1.56556678313579, -3.12760705106236, -2.82695133199393,
                                          -1.30240004011893, 2.5298221281347, 0.402880362040626), rad = c(1.3,
                                                                                                          1.3, 1, 1, 1, 1, 1, 1, 1), centroid = c(0, 0),
           clRad = 4.58851376253731)

c1_shifted_by_4_5 <- list(x = c(2.7, 5.3, 4, 2.02272760131755, 3.27173929116512, 5.24901168984757,
                                6.54351675296717, 4, 7.58851376253731), y = c(5.63245553203368,
                                                                              5.63245553203368, 3.73508893593265, 3.43443321686421, 1.87239294893764,
                                                                              2.17304866800607, 3.69759995988107, 7.5298221281347, 5.40288036204063
                                ), rad = c(1.3, 1.3, 1, 1, 1, 1, 1, 1, 1), centroid = c(4, 5),
                          clRad = 4.58851376253731)

c1_shifted_to_9_0 <- list(x = c(7.7, 10.3, 9, 7.02272760131755, 8.27173929116512,
                                10.2490116898476, 11.5435167529672, 9, 12.5885137625373), y = c(0.632455532033676,
                                                                                                0.632455532033676, -1.26491106406735, -1.56556678313579, -3.12760705106236,
                                                                                                -2.82695133199393, -1.30240004011893, 2.5298221281347, 0.402880362040626
                                ), rad = c(1.3, 1.3, 1, 1, 1, 1, 1, 1, 1), centroid = c(9, 0),
                          clRad = 4.58851376253731)

c2 <- list(x = c(1.01965811965812, 4.91965811965812, 3.06068376068376,
                 -0.0162220916735012, 1.7444464911405, 4.73780346374527), y = c(4.98850135349066,
                                                                                4.98850135349066, 2.02299729301867, 1.64530644625424, -0.783694612101178,
                                                                                -0.584160067326664), rad = c(2, 1.9, 1.6, 1.5, 1.5, 1.5), centroid = c(3,
                                                                                                                                                       4), clRad = 3.81965811965812)

c3 <- list(x = c(19.2380952380952, 20.6380952380952, 20.1238095238095,
                 19.042322998886, 21.2139455087874), y = c(20.3614031611621, 20.3614031611621,
                                                           19.2771936776758, 19.076228764298, 19.424175085535), rad = c(0.8,
                                                                                                                        0.6, 0.6, 0.5, 0.5), centroid = c(20, 20), clRad = 1.71394550878742)

test_cluster_lists <- list(
  c1, c1_shifted_by_4_5, c1_shifted_to_9_0, c2, c3
)

test_centroids <- list(
  "c1" = c1[[4]],
  "c1_shifted_by_4_5" = c1_shifted_by_4_5[[4]],
  "c1_shifted_to_9_0" = c1_shifted_to_9_0[[4]],
  "c2" = c2[[4]],
  "c3" = c3[[4]]
)

test_radii <- list(
  "c1" = c1[[3]],
  "c1_shifted_by_4_5" = c1_shifted_by_4_5[[3]],
  "c1_shifted_to_9_0" = c1_shifted_to_9_0[[3]],
  "c2" = c2[[3]],
  "c3" = c3[[3]]
)
