% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_logs.R
\name{meta_clean_logs}
\alias{meta_clean_logs}
\title{Run \code{clean_logs()} on the output from \code{clean_metadata()}}
\usage{
meta_clean_logs(meta)
}
\arguments{
\item{meta}{Data frame. \code{meta} data processed in \code{add_sites()}}
}
\value{
Data frame containing
\itemize{
\item \code{file_name}s and \code{path}s of the log files
\item \code{event}s and their \code{date_time}s
\item \code{lat} and \code{lon} for "gps" events
\item \code{rec_file}, \code{rec_size} and \code{rec_end} for "recording" events
(recording start is the \code{date_time} of the event)
\item \code{schedule} information such as \code{schedule_date}, \code{schedule_name},
\code{schedule_lat}, \code{schedule_lon}, \code{schedule_sr} (sunrise),
and \code{schedule_ss} (sunset)
\item \code{meta}data information such as \code{meta_serial} and \code{meta_firmware}
\item other columns from meta provided
}
}
\description{
Run \code{clean_logs()} on the output from \code{clean_metadata()}
}
\examples{

  file_vec <- fs::dir_ls(fs::path_package("extdata", package = "ARUtools"), recurse = TRUE,)
  m <- clean_metadata(project_files = file_vec, file_type = 'json',pattern_site_id = "000\\\\d+" )

  logs <- meta_clean_logs(m)
}
