% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{aggregate_and_extract_gamma}
\alias{aggregate_and_extract_gamma}
\title{Aggregate Individual Survey Data and Extract Gamma Parameters by Location}
\usage{
aggregate_and_extract_gamma(
  data,
  lat_column = "lat",
  long_column = "long",
  age_column = "ageyrs",
  urban_column = "urban"
)
}
\arguments{
\item{data}{Data frame containing individual-level age data with
coordinates and urban/rural classification.}

\item{lat_column}{Column name for latitude coordinates (default: "lat")}

\item{long_column}{Column name for longitude coordinates (default: "long")}

\item{age_column}{Column name for age values (default: "ageyrs")}

\item{urban_column}{Column name for urban/rural classification (default:
"urban")}
}
\value{
List containing:
        \itemize{
          \item outlier_free_data: Original data with added spatial
                 coordinates, outliers removed, and clusters with less than
                 10 samples removed
          \item age_param_data: Location-level gamma parameters with columns:
                lon, lat, web_x, web_y, log_scale, log_shape, urban,
                b1, c, b2, nsampled
        }
}
\description{
This script aggregates the individual Survey data to location level and extracts
the gamma parameters for the locations.
}
