% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_interaction_function.R
\name{plot_interaction}
\alias{plot_interaction}
\title{Graph: Interaction plot}
\usage{
plot_interaction(
  a,
  box_label = TRUE,
  repel = FALSE,
  pointsize = 3,
  linesize = 0.8,
  width.bar = 0.05,
  add.errorbar = TRUE,
  family = "sans"
)
}
\arguments{
\item{a}{FAT2DIC, FAT2DBC, PSUBDIC or PSUBDBC object}

\item{box_label}{Add box in label}

\item{repel}{a boolean, whether to use ggrepel to avoid overplotting text labels or not.}

\item{pointsize}{Point size}

\item{linesize}{Line size (Trendline and Error Bar)}

\item{width.bar}{width of the error bars.}

\item{add.errorbar}{Add error bars.}

\item{family}{Font family}
}
\value{
Returns an interaction graph with averages and letters from the multiple comparison test
}
\description{
Performs an interaction graph from an output of the FAT2DIC, FAT2DBC, PSUBDIC or PSUBDBC commands.
}
\examples{
data(cloro)
a=with(cloro, FAT2DIC(f1, f2, resp))
plot_interaction(a)
}
\author{
Gabriel Danilo Shimizu, \email{gabrield.shimizu@gmail.com}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
