% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/250605_axSvm_v0.99.6.R
\name{axSvm}
\alias{axSvm}
\title{Build SVM Classifier for Axon Image Feature Classification}
\usage{
axSvm(
  nCst = 3,
  nGmm = 0.1,
  nCrss = 5,
  degenerate_path = NULL,
  intact_path = NULL,
  output_data_path = tempdir(),
  output_model_path = tempdir()
)
}
\arguments{
\item{nCst}{Numeric. SVM cost parameter (C-value) controlling margin hardness.
Higher values increase model complexity. (default: 3)}

\item{nGmm}{Numeric. SVM gamma parameter ( (\eqn{\gamma})-value) controlling RBF kernel width.
Smaller values mean larger kernel radius. (default: 0.1)}

\item{nCrss}{Integer. Number of folds for cross-validation.
Recommended values 5-10. (default: 5)}

\item{degenerate_path}{Character vector. Path to feature data for the "Degenerate" group
(folder containing .txt files or direct file path). If NULL, GUI selection
dialog will be shown. (default: NULL)}

\item{intact_path}{Character vector. Path to feature data for the "Intact" group
(folder containing .txt files or direct file path). If NULL, GUI selection
dialog will be shown. (default: NULL)}

\item{output_data_path}{Character. Path to save combined feature data (TSV).
If NULL, GUI save dialog will be shown. (default: NULL)
If a directory is specified, the file will be saved there with an autogenerated name.
If a file name already exists, a unique name will be generated.(default: NULL)}

\item{output_model_path}{Character. Path to save trained SVM model (Rdata format).
If NULL, GUI save dialog will be shown.
If a directory is specified, the file will be saved there with an autogenerated name.
If a file name already exists, a unique name will be generated.(default: NULL)}
}
\value{
Invisibly returns the trained SVM model object and produces the following outputs:
\itemize{
\item Combined feature data file for machine learning (TSV).
\item Trained SVM model file (Rdata format)
}
}
\description{
Trains a Support Vector Machine (SVM) classifier to distinguish between degenerative
and intact axon states using image feature data. Supports both direct path input
and interactive GUI selection.
}
\details{
The function implements a complete machine learning pipeline:
\enumerate{
\item \strong{Input handling}: If input paths are not specified, the user is prompted to select folders via a GUI dialog (cross-platform support for RStudio, tcltk, svDialogs, or manual input).
\item \strong{Data preprocessing}: The function reads all .txt files in the specified folders, merges data, and labels them as "Degenerate" or "Intact".
\item \strong{Feature selection}: Focuses on 7 key morphological features:
\itemize{
\item m.eccentricity (elliptical eccentricity)
\item s.radius.sd (radial distribution uniformity)
\item h.sva.s2 (Sum Variance: scale=2)
\item h.idm.s1 (Inverse Difference Moment: local homogeneity scale=1)
\item h.sen.s1 (Sum Entropy: structural complexity scale=1)
\item m.majoraxis (major axis length)
}
\item \strong{Model training and evaluation}: Utilizes the e1071 package with a radial basis function (RBF) kernel. Cross-validation is performed.
\item \strong{Result saving}: Exports the merged feature data and trained SVM model to disk, ensuring unique filenames if necessary.
}

#' @section File Naming and Overwrite Policy:
\itemize{
\item If the output path is an existing file, a unique name with a numeric suffix is generated to avoid overwriting.
\item If the output path is an existing directory, the output file will be saved there with a default name (date-based).
\item If the directory does not exist, the file will be saved in the current working directory.
}
All steps are performed automatically, requiring minimal user intervention.
}
\note{
\itemize{
\item Compatible with feature data from \code{\link{axDistmap}}
\item Output files include timestamp in ISO 8601 format (YYYY-MM-DD)
\item Model files can be reloaded using base::load()
}
}
\section{GUI Support}{

\itemize{
\item RStudio (rstudioapi), tcltk and svDialogs are supported for file/folder selection.
\item If no GUI is available, the user is prompted to enter the path manually.
}
}

\examples{
# Interactive mode with GUI prompts
# NOTE: This example requires a GUI environment for interactive folder selection.
if (interactive()){
axSvm()
}


# Direct path specification
\donttest{
deg_dir <- system.file("extdata", "Degenerate_txt", package = "AiES")
int_dir <- system.file("extdata", "Intact_txt", package = "AiES")
axSvm(degenerate_path = deg_dir, intact_path = int_dir,
      output_data_path = file.path(tempdir(), "svm_test_data.txt"),
      output_model_path = file.path(tempdir(), "svm_test_model.svm"))

# Custom hyperparameters
deg_dir <- system.file("extdata", "Degenerate_txt", package = "AiES")
int_dir <- system.file("extdata", "Intact_txt", package = "AiES")
axSvm(degenerate_path = deg_dir, intact_path = int_dir,
     nCst = 5, nGmm = 0.05, nCrss = 10,
  output_data_path = tempdir(),       # specify directory only
  output_model_path = tempdir()       # specify directory only
)
}

# Specify only output directory; default file names will be used
deg_dir <- system.file("extdata", "Degenerate_txt", package = "AiES")
int_dir <- system.file("extdata", "Intact_txt", package = "AiES")
axSvm(degenerate_path = deg_dir, intact_path = int_dir,
  output_data_path = tempdir(),       # specify directory only
  output_model_path = tempdir()       # specify directory only
)

# In this case, output files will be saved as:
#   results/YYYY-MM-DD_Extracted_data_for_ML.txt
#   results/YYYY-MM-DD_AxClassifier.svm
# (YYYY-MM-DD is the current date)

}
