% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparisonallocations.R
\name{comparisonallocations}
\alias{comparisonallocations}
\title{Graphical evaluation of the contribution vectors}
\usage{
comparisonallocations(
  c,
  contributions,
  col = NULL,
  colors = NULL,
  agents_names = NULL,
  labels = TRUE,
  legend = NULL,
  tol = 1e-06
)
}
\arguments{
\item{c}{A numeric cost vector.}

\item{contributions}{A list containing the different cost allocation vectors to be compared.
It is required that the sum of the coordinates of each vector equals the total cost to be allocated.}

\item{col}{A character string reflecting the color of the NS constraint for each agent. By default, the color \code{"dodgerblue"} is used.}

\item{colors}{A vector that indicates the colors used to represent each contribution vector. By default, a color palette of different shades is used.}

\item{agents_names}{A vector defining the name assigned to each agent. By default, the names follow a sequence of natural numbers, starting from 1.}

\item{labels}{A logical value indicating whether the labels and the title of the plot should be displayed. By default, \code{labels = TRUE}.}

\item{legend}{A vector or list where each of its elements represents a different contribution vector.
By default, the coordinates of each contribution vector are displayed with two decimal places.}

\item{tol}{Tolerance level for evaluating compliance with the NS constraint.}
}
\value{
A vertical line plot in which each line represents the maximum amount an agent can pay without violating the NS constraint,
while the points along the lines indicate the contributions made by the agent.
}
\description{
\code{comparisonallocations} generates a graphical representation in which, for each agent or group of clones,
both the maximum cost they can bear and their corresponding marginal contribution are displayed.
}
\details{
For each \eqn{c\in C^N} let \eqn{H(c)=\{x\in\mathbb{R}:x(N)=c_n\}} be the hyperplane of \eqn{\mathbb{R}^N}
given by all the vectors whose coordinates add up to \eqn{c_n}. A cost allocation for \eqn{c\in C^N} is a vector
\eqn{x\in H(c)} such that \eqn{0\leq x\leq c}. The component \eqn{x_i} is the contribution requested from agent \eqn{i}.
Let \eqn{X(c)} be the set of cost allocations for \eqn{c\in C^N}.

A basic requirement is that at an allocation \eqn{x\in X(c)} on group \eqn{N'\subset N}
of agents would subsidize the other agents by contributing more than what the group would have to pay on its own. The no-subsidy constraint
for the group \eqn{N'\subset N} is \eqn{x(N')\geq \text{max}\{c_j:j\in N'\}}. The set of cost allocations for \eqn{c\in C^N} that satisfy the no-subsidy
constraints, the no-subsidy set for short, is given by:
\deqn{
NS(c)=\{x\in X(c):x(N')\leq\text{max}\{c_j:j\in N'\}, \text{ for all } N'\subset N\}}
\deqn{= \{x\in \mathbb{R}^N:x\geq 0, \ x(N)=c_n, \ x_1+\dots+x_i\leq c_i,\text{ for all }i\in N\backslash \{n\}\}
}
Thus, the no-subsidy correspondence NS assigns to each \eqn{c\in C^N} the set \eqn{NS(c)}.

A rule is a mapping \eqn{\mathcal{R}:C^N\rightarrow \mathbb{R}^N} which associates with each problem \eqn{c\in C^N} a contribution vector
\eqn{\mathcal{R}(c)\in X(c)}. In other words, a rule is a mechanism that, for each airport problem, selects an allocation vector belonging to its no-subsidy set.
}
\examples{
# CEB rule vs weighted CEB rule vs clones CEB rule
c <- c(1, 3, 7, 10) # Cost vector
w <- c(1, 4, 8, 2) # Weight vector
eta <- w # Size of each groups of clones
CEB <- basicrule(c, "CEB")
wCEB <- weightedrule(c, w, "CEB")
clCEB <- clonesrule(c, w, "CEB")
comparisonallocations(c, list(CEB, wCEB, clCEB))

# SEC rule vs CEC rule vs SM rule
c <- c(5, 10, 20) # Cost vector
comparisonallocations(c, list(SECrule(c), CECrule(c), SMrule(c)),
col = "green", agents_names = c("Alex", "Estela", "Carmen"), labels = FALSE,
legend = list("SEC", "CEC", "SM"))

}
\references{
Bernárdez Ferradás, A., Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2025). Airport problems with cloned agents. [Preprint manuscript].

Thomson, W. (2024). Cost allocation and airport problems.
\emph{Mathematical Social Sciences}, 31(C), 17–31.
}
\seealso{
\code{\link{NScheck}}, \code{\link{basicrule}}, \code{\link{plotallocations}}
}
