% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh_aseba.R
\name{compute_mh_p_cbcl__sct_sum}
\alias{compute_mh_p_cbcl__sct_sum}
\title{Compute "Child Behavior Checklist [Parent] (Sluggish Cognitive Tempo): Sum"}
\usage{
compute_mh_p_cbcl__sct_sum(
  data,
  name = "mh_p_cbcl__sct_sum",
  max_na = 0,
  exclude = c("777", "999"),
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. Name of the summary score column.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed. \code{NULL} means no limit.}

\item{exclude}{character vector. Values to be excluded from the summary score.}

\item{combine}{logical. If \code{TRUE} (default), the summary score is
is appended as a new column to the input data frame. If \code{FALSE}, the
summary score is returned as a separate one-column data frame.}
}
\value{
tbl. see \code{combine}.
}
\description{
Computes the summary score \code{mh_p_cbcl__sct_sum}
Child Behavior Checklist [Parent] (Sluggish Cognitive Tempo): Sum
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_p_cbcl__wthdep__dep_002}
\item \code{mh_p_cbcl__attn_002}
\item \code{mh_p_cbcl__attn_003}
\item \code{mh_p_cbcl__attn_005}
}
\item \emph{Excluded values:}
\itemize{
\item 777
\item 999
}
\item \emph{Validation criterion:} maximally 0 of 4 items missing
}
}
\examples{
\dontrun{
compute_mh_p_cbcl__sct_sum(data) |>
  select(
    any_of(c("mh_p_cbcl__sct_sum", vars_mh_p_cbcl__sct))
  )
}
}
\seealso{
\code{\link[=compute_mh_p_cbcl__sct_nm]{compute_mh_p_cbcl__sct_nm()}}
}
