% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh.R
\name{compute_mh_y_bisbas__bis_sum}
\alias{compute_mh_y_bisbas__bis_sum}
\title{Compute "The Behavioral Inhibition System/Behavioral Activation System
Scales [Youth] (BIS): Sum"}
\usage{
compute_mh_y_bisbas__bis_sum(
  data,
  name = "mh_y_bisbas__bis_sum",
  max_na = 0,
  exclude = NULL,
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. Name of the summary score column.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed. \code{NULL} means no limit.}

\item{exclude}{character vector. Values to be excluded from the summary
score calculation.}

\item{combine}{logical. If \code{TRUE} (default), the summary score is
is appended as a new column to the input data frame. If \code{FALSE}, the
summary score is returned as a separate one-column data frame.}
}
\value{
tbl. see \code{combine}.
}
\description{
Computes the summary score \code{mh_y_bisbas__bis_sum}
The Behavioral Inhibition System/Behavioral Activation System Scales
[Youth] (BIS): Sum
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_y_bisbas__bis_001}
\item \code{mh_y_bisbas__bis_002}
\item \code{mh_y_bisbas__bis_003}
\item \code{mh_y_bisbas__bis_004}
\item \code{mh_y_bisbas__bis_005}
\item \code{mh_y_bisbas__bis_006}
\item \code{mh_y_bisbas__bis_007}
}
\item \emph{Excluded values:} none
\item \emph{Validation criterion:} none of 7 items missing
}
}
\examples{
\dontrun{
compute_mh_y_bisbas__bis_sum(data) |>
  select(
    any_of(c("mh_y_bisbas__bis_sum", vars_mh_y_bisbas__bis))
  )
}
}
\seealso{
\code{\link[=compute_mh_y_bisbas__bis_nm]{compute_mh_y_bisbas__bis_nm()}}
}
