% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SNKTest.R
\name{SNKTest}
\alias{SNKTest}
\title{Student-Newman-Keuls (SNK) Test for Multiple Comparisons}
\usage{
SNKTest(modelo, alpha = 0.05)
}
\arguments{
\item{modelo}{An object of class \code{aov} or \code{lm} representing an ANOVA model.}

\item{alpha}{Significance level (default is 0.05).}
}
\value{
An object of class \code{"snk"} and \code{"comparaciones"}, containing:
\itemize{
  \item \code{Resultados}: A data frame with pairwise comparisons, including mean differences,
  critical values, p-values, and significance codes.
  \item \code{Promedios}: A named numeric vector of group means.
  \item \code{Orden_Medias}: A character vector with group names ordered from highest to lowest mean.
  \item \code{Metodo}: A character string indicating the test used ("SNK").
}
}
\description{
Performs the Student-Newman-Keuls (SNK) post hoc test for pairwise comparisons
after fitting an ANOVA model. The test uses a stepwise approach where the
critical value depends on the number of means spanned between groups (range r).
}
\details{
SNK is more powerful but less conservative than Tukey’s HSD, increasing the chance of
detecting real differences while slightly raising the Type I error rate.

Assumptions: normality, homogeneity of variances, and independence of observations.

Advantages:
- More powerful than Tukey when differences are large.
- Intermediate control of Type I error.

Disadvantages:
- Error control is not family-wise.
- Type I error increases with more comparisons.
}
\examples{
data(d_e, package = "Analitica")
mod <- aov(Sueldo_actual ~ as.factor(labor), data = d_e)
resultado <- SNKTest(mod)
summary(resultado)
plot(resultado)

}
\references{
Student, Newman, and Keuls (1952). "Student-Newman-Keuls Procedure".
See also: <https://doi.org/10.1002/bimj.200310019>
}
