% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{Smoking}
\alias{Smoking}
\alias{cost}
\alias{data}
\alias{eff}
\alias{life.years}
\alias{pi_post}
\alias{smoking}
\alias{smoking_output}
\alias{treats}
\title{Smoking Cessation Cost-Effectiveness Data}
\format{
A list containing the variables for the cost-effectiveness analysis:
\describe{
\item{cost}{A matrix of 500 simulations from the posterior distribution
of the overall costs for the four strategies.}
\item{data}{A dataset with characteristics of smokers in the UK population.}
\item{eff}{A matrix of 500 simulations from the posterior distribution of
the clinical benefits for the four strategies.}
\item{life.years}{A matrix of 500 simulations from the posterior
distribution of the life years gained with each strategy.}
\item{pi_post}{A matrix of 500 simulations from the posterior
distribution of the probability of smoking cessation with each strategy.}
\item{smoking}{A data frame with inputs for the network meta-analysis,
containing: \code{nobs} (record ID), \code{s} (study ID), \code{i}
(intervention ID), \code{r_i} (number of patients who quit),
\code{n_i} (total patients in arm), and \code{b_i} (reference
intervention for the study).}
\item{smoking_output}{A matrix of results from the network meta-analysis model
run on the \code{smoking} object.}
\item{treats}{A character vector of labels for the four strategies.}
}
}
\source{
Effectiveness data adapted from Hasselblad V. (1998). "Meta-analysis
of Multitreatment Studies". \emph{Medical Decision Making}, 18:37-43.

Cost and population data adapted from various sources:
\itemize{
\item Taylor, D.H. Jr, et al. (2002). "Benefits of smoking
cessation on longevity". \emph{American Journal of Public Health}, 92(6).
\item Action on Smoking and Health (ASH) (2013). "ASH fact sheet on smoking
statistics". \url{https://ash.org/wp-content/uploads/2014/05/ASH-Annual-Report-2014.pdf}.
\item Flack, S., et al. (2007). "Cost-effectiveness of interventions for smoking
cessation". \emph{York Health Economics Consortium}.
\item McGhan, W.F.D., and Smith, M. (1996). "Pharmacoeconomic analysis of
smoking-cessation interventions". \emph{American Journal of Health-System Pharmacy}, 53:45-52.
}
}
\description{
This data set contains the results of a Bayesian analysis modeling the
clinical outputs and costs for an economic evaluation of four different
smoking cessation interventions.
}
\references{
Baio G. (2012). \emph{Bayesian Methods in Health Economics}. CRC/Chapman & Hall, London.
}
\keyword{datasets}
