% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.hclustering.R
\name{is.hclustering}
\alias{is.hclustering}
\title{Reports whether x is a 'hclustering' object}
\usage{
is.hclustering(x)
}
\arguments{
\item{x}{an object to test.}
}
\value{
Returns TRUE if its argument is of class \code{hclustering} and FALSE otherwise.
}
\description{
Reports whether x is a 'hclustering' object
}
\examples{
data <- data.frame(Pbox$PTS,Pbox$P3M,
                   Pbox$OREB + Pbox$DREB, Pbox$AST,
                   Pbox$TOV, Pbox$STL, Pbox$BLK,Pbox$PF)
names(data) <- c("PTS","P3M","REB","AST","TOV","STL","BLK","PF")
data <- subset(data, Pbox$MIN >= 1500)
ID <- Pbox$Player[Pbox$MIN >= 1500]
hclu <- hclustering(data, labels=ID, k=7)
is.hclustering(hclu)
}
\references{
P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.
}
\seealso{
\code{\link{hclustering}}
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketball.analyzer.help@gmail.com})
}
