% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ermod_exp_cov_sel.R
\name{plot_er_exp_sel}
\alias{plot_er_exp_sel}
\title{Plot exposure metric selection comparison}
\usage{
plot_er_exp_sel(x, n_draws_sim = NULL)
}
\arguments{
\item{x}{An object of class \code{ermod_bin_exp_sel}}

\item{n_draws_sim}{Number of draws to simulate response for each exposure
value. Default is NULL (use all draws in the model object)}
}
\value{
No return value, called for plotting side effect.
}
\description{
Plot ER curve for each exposure metric and compare them.
}
\examples{
\donttest{
data(d_sim_binom_cov_hgly2)

ermod_bin_exp_sel <-
  dev_ermod_bin_exp_sel(
    data = d_sim_binom_cov_hgly2,
    var_resp = "AEFLAG",
    var_exp_candidates = c("AUCss_1000", "Cmaxss", "Cminss")
  )

plot_er_exp_sel(ermod_bin_exp_sel) + xgxr::xgx_scale_x_log10()
}

}
