% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_HRFs.R
\name{cderiv}
\alias{cderiv}
\title{Central derivative}
\usage{
cderiv(x)
}
\arguments{
\item{x}{A numeric matrix, or a vector which will be converted to a
single-column matrix.}
}
\value{
A matrix or vector the same dimensions as \code{x}, with the
derivative taken for each column of \code{x}. The first and last rows may
need to be deleted, depending on the application.
}
\description{
Take the central derivative of numeric vectors by averaging the forward and
backward differences.
}
\examples{
x <- cderiv(seq(5))
stopifnot(all(x == c(.5, 1, 1, 1, .5)))

}
