% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.BchronologyRun.R
\name{predict.BchronologyRun}
\alias{predict.BchronologyRun}
\title{Predict ages of other positions for a BchronologyRun object}
\usage{
\method{predict}{BchronologyRun}(
  object,
  newPositions,
  newPositionThicknesses = NULL,
  maxExtrap = 500,
  ...
)
}
\arguments{
\item{object}{Output from a run of \code{\link{Bchronology}}}

\item{newPositions}{A vector of new positions at which to find ages}

\item{newPositionThicknesses}{A vector of thicknesses for the above positions. Must be the same length as \code{newPositions}. If \code{NULL} then assumed zero}

\item{maxExtrap}{The maximum new of extrapolation attempts. It might be worth increasing this if you are extrapolating a long way from the other dated positions}

\item{...}{Other arguments to predict (not currently supported)}
}
\value{
A matrix of dimension num_samples by num_positions so that each row represents a set of monotonic sample predicted ages
}
\description{
This function will predict the ages of new positions (usually depths) based on a previous run of the function \code{\link{Bchronology}}. It will also allow for thickness uncertainties to be included in the resulting ages, for example when the age of a particular event is desired
}
\seealso{
\code{\link{BchronCalibrate}}, \code{\link{Bchronology}} \code{\link{BchronRSL}}, \code{\link{BchronDensity}}, \code{\link{BchronDensityFast}}
}
