/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.operators;

import dr.evomodel.coalescent.OldGMRFSkyrideLikelihood;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import java.util.logging.Logger;
import no.uib.cipr.matrix.BandCholesky;
import no.uib.cipr.matrix.DenseCholesky;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.SPDTridiagMatrix;
import no.uib.cipr.matrix.SymmTridiagMatrix;
import no.uib.cipr.matrix.UpperSPDBandMatrix;
import no.uib.cipr.matrix.UpperSPDDenseMatrix;
import no.uib.cipr.matrix.UpperTriangBandMatrix;
import no.uib.cipr.matrix.UpperTriangDenseMatrix;
import no.uib.cipr.matrix.Vector;

public class GMRFSkyrideBlockUpdateOperator
extends AbstractAdaptableOperator {
    private static boolean FAIL_SILENTLY = true;
    private double scaleFactor;
    private double lambdaScaleFactor;
    private int fieldLength;
    private int maxIterations;
    private double stopValue;
    private Parameter popSizeParameter;
    private Parameter precisionParameter;
    private Parameter lambdaParameter;
    OldGMRFSkyrideLikelihood gmrfField;
    private double[] zeros;

    public GMRFSkyrideBlockUpdateOperator(OldGMRFSkyrideLikelihood oldGMRFSkyrideLikelihood, double d, AdaptationMode adaptationMode, double d2, int n, double d3) {
        super(adaptationMode);
        this.gmrfField = oldGMRFSkyrideLikelihood;
        this.popSizeParameter = oldGMRFSkyrideLikelihood.getPopSizeParameter();
        this.precisionParameter = oldGMRFSkyrideLikelihood.getPrecisionParameter();
        this.lambdaParameter = oldGMRFSkyrideLikelihood.getLambdaParameter();
        this.scaleFactor = d2;
        this.lambdaScaleFactor = 0.0;
        this.fieldLength = this.popSizeParameter.getDimension();
        this.maxIterations = n;
        this.stopValue = d3;
        this.setWeight(d);
        this.zeros = new double[this.fieldLength];
    }

    private double getNewLambda(double d, double d2) {
        double d3 = MathUtils.nextDouble() * d2 - d2 / 2.0;
        double d4 = d + d3;
        if (d4 > 1.0) {
            d4 = 2.0 - d4;
        }
        if (d4 < 0.0) {
            d4 = -d4;
        }
        return d4;
    }

    private double getNewPrecision(double d, double d2) {
        double d3 = d2 - 1.0 / d2;
        if (d2 == 1.0) {
            return d;
        }
        double d4 = MathUtils.nextDouble() < d3 / (d3 + 2.0 * Math.log(d2)) ? (1.0 / d2 + d3 * MathUtils.nextDouble()) * d : Math.pow(d2, 2.0 * MathUtils.nextDouble() - 1.0) * d;
        return d4;
    }

    public DenseVector getMultiNormalMean(DenseVector denseVector, BandCholesky bandCholesky) {
        DenseVector denseVector2 = new DenseVector(this.zeros);
        DenseVector denseVector3 = new DenseVector(this.zeros);
        UpperTriangBandMatrix upperTriangBandMatrix = bandCholesky.getU();
        upperTriangBandMatrix.transSolve(denseVector, denseVector2);
        upperTriangBandMatrix.solve(denseVector2, denseVector3);
        return denseVector3;
    }

    public DenseVector getMultiNormal(DenseVector denseVector, DenseVector denseVector2, BandCholesky bandCholesky) {
        DenseVector denseVector3 = new DenseVector(this.zeros);
        UpperTriangBandMatrix upperTriangBandMatrix = bandCholesky.getU();
        upperTriangBandMatrix.solve(denseVector, denseVector3);
        denseVector3.add(denseVector2);
        return denseVector3;
    }

    public static DenseVector getMultiNormal(DenseVector denseVector, UpperSPDDenseMatrix upperSPDDenseMatrix) {
        int n = denseVector.size();
        DenseVector denseVector2 = new DenseVector(n);
        DenseVector denseVector3 = new DenseVector(n);
        UpperSPDDenseMatrix upperSPDDenseMatrix2 = upperSPDDenseMatrix.copy();
        for (int i = 0; i < denseVector3.size(); ++i) {
            denseVector2.set(i, MathUtils.nextGaussian());
        }
        DenseCholesky denseCholesky = new DenseCholesky(n, true);
        denseCholesky.factor(upperSPDDenseMatrix2);
        UpperTriangDenseMatrix upperTriangDenseMatrix = denseCholesky.getU();
        upperTriangDenseMatrix.transMult(denseVector2, denseVector3);
        denseVector3.add(denseVector);
        return denseVector3;
    }

    public static double logGeneralizedDeterminant(UpperTriangBandMatrix upperTriangBandMatrix) {
        double d = 0.0;
        for (int i = 0; i < upperTriangBandMatrix.numColumns(); ++i) {
            if (!(upperTriangBandMatrix.get(i, i) > 1.0E-7)) continue;
            d += Math.log(upperTriangBandMatrix.get(i, i));
        }
        return d;
    }

    public DenseVector newtonRaphson(double[] dArray, DenseVector denseVector, SymmTridiagMatrix symmTridiagMatrix) {
        return GMRFSkyrideBlockUpdateOperator.newNewtonRaphson(dArray, denseVector, symmTridiagMatrix, this.maxIterations, this.stopValue);
    }

    public static DenseVector newNewtonRaphson(double[] dArray, DenseVector denseVector, SymmTridiagMatrix symmTridiagMatrix, int n, double d) {
        DenseVector denseVector2 = denseVector.copy();
        DenseVector denseVector3 = denseVector.copy();
        int n2 = 0;
        while (GMRFSkyrideBlockUpdateOperator.gradient(dArray, denseVector2, symmTridiagMatrix).norm(Vector.Norm.Two) > d) {
            try {
                GMRFSkyrideBlockUpdateOperator.jacobian(dArray, denseVector2, symmTridiagMatrix).solve(GMRFSkyrideBlockUpdateOperator.gradient(dArray, denseVector2, symmTridiagMatrix), denseVector3);
            }
            catch (MatrixNotSPDException matrixNotSPDException) {
                if (FAIL_SILENTLY) {
                    return null;
                }
                Logger.getLogger("dr.evomodel.coalescent.operators.GMRFSkyrideBlockUpdateOperator").fine("Newton-Raphson F");
                throw new RuntimeException("Newton-Raphson F.");
            }
            catch (MatrixSingularException matrixSingularException) {
                if (FAIL_SILENTLY) {
                    return null;
                }
                Logger.getLogger("dr.evomodel.coalescent.operators.GMRFSkyrideBlockUpdateOperator").fine("Newton-Raphson F");
                throw new RuntimeException("Newton-Raphson F.");
            }
            denseVector2.add(denseVector3);
            if (++n2 <= n) continue;
            if (FAIL_SILENTLY) {
                return null;
            }
            Logger.getLogger("dr.evomodel.coalescent.operators.GMRFSkyrideBlockUpdateOperator").fine("Newton-Raphson F");
            throw new RuntimeException("Newton Raphson algorithm did not converge within " + n + " step to a norm less than " + d + "\nTry starting BEAST with a more accurate initial tree.");
        }
        Logger.getLogger("dr.evomodel.coalescent.operators.GMRFSkyrideBlockUpdateOperator").fine("Newton-Raphson S");
        return denseVector2;
    }

    private static DenseVector gradient(double[] dArray, DenseVector denseVector, SymmTridiagMatrix symmTridiagMatrix) {
        DenseVector denseVector2 = new DenseVector(denseVector.size());
        symmTridiagMatrix.mult(denseVector, denseVector2);
        for (int i = 0; i < denseVector.size(); ++i) {
            denseVector2.set(i, -denseVector2.get(i) - 1.0 + dArray[i] * Math.exp(-denseVector.get(i)));
        }
        return denseVector2;
    }

    private static SPDTridiagMatrix jacobian(double[] dArray, DenseVector denseVector, SymmTridiagMatrix symmTridiagMatrix) {
        SPDTridiagMatrix sPDTridiagMatrix = new SPDTridiagMatrix(symmTridiagMatrix, true);
        int n = denseVector.size();
        for (int i = 0; i < n; ++i) {
            sPDTridiagMatrix.set(i, i, sPDTridiagMatrix.get(i, i) + Math.exp(-denseVector.get(i)) * dArray[i]);
        }
        return sPDTridiagMatrix;
    }

    @Override
    public double doOperation() {
        int n;
        double d = this.precisionParameter.getParameterValue(0);
        double d2 = this.getNewPrecision(d, this.scaleFactor);
        double d3 = this.lambdaParameter.getParameterValue(0);
        double d4 = this.getNewLambda(d3, this.lambdaScaleFactor);
        this.precisionParameter.setParameterValue(0, d2);
        this.lambdaParameter.setParameterValue(0, d4);
        DenseVector denseVector = new DenseVector(this.gmrfField.getPopSizeParameter().getParameterValues());
        SymmTridiagMatrix symmTridiagMatrix = this.gmrfField.getStoredScaledWeightMatrix(d, d3);
        SymmTridiagMatrix symmTridiagMatrix2 = this.gmrfField.getScaledWeightMatrix(d2, d4);
        double[] dArray = this.gmrfField.getSufficientStatistics();
        UpperSPDBandMatrix upperSPDBandMatrix = new UpperSPDBandMatrix(symmTridiagMatrix2, 1);
        UpperSPDBandMatrix upperSPDBandMatrix2 = new UpperSPDBandMatrix(symmTridiagMatrix, 1);
        BandCholesky bandCholesky = new BandCholesky(dArray.length, 1, true);
        BandCholesky bandCholesky2 = new BandCholesky(dArray.length, 1, true);
        DenseVector denseVector2 = new DenseVector(this.fieldLength);
        DenseVector denseVector3 = new DenseVector(this.fieldLength);
        DenseVector denseVector4 = new DenseVector(this.fieldLength);
        DenseVector denseVector5 = this.newtonRaphson(dArray, denseVector, symmTridiagMatrix2.copy());
        if (denseVector5 == null) {
            return Double.NEGATIVE_INFINITY;
        }
        for (int i = 0; i < this.fieldLength; ++i) {
            denseVector2.set(i, dArray[i] * Math.exp(-denseVector5.get(i)));
            denseVector3.set(i, denseVector5.get(i) + 1.0);
            upperSPDBandMatrix.set(i, i, denseVector2.get(i) + upperSPDBandMatrix.get(i, i));
            denseVector2.set(i, denseVector2.get(i) * denseVector3.get(i) - 1.0);
        }
        bandCholesky.factor(upperSPDBandMatrix.copy());
        DenseVector denseVector6 = this.getMultiNormalMean(denseVector2, bandCholesky);
        DenseVector denseVector7 = new DenseVector(this.zeros);
        for (n = 0; n < this.zeros.length; ++n) {
            denseVector7.set(n, MathUtils.nextGaussian());
        }
        DenseVector denseVector8 = this.getMultiNormal(denseVector7, denseVector6, bandCholesky);
        for (n = 0; n < this.fieldLength; ++n) {
            this.popSizeParameter.setParameterValueQuietly(n, denseVector8.get(n));
        }
        ((Parameter.Abstract)this.popSizeParameter).fireParameterChangedEvent();
        double d5 = 0.0;
        denseVector2.zero();
        denseVector3.zero();
        denseVector4.zero();
        DenseVector denseVector9 = this.newtonRaphson(dArray, denseVector8, symmTridiagMatrix.copy());
        if (denseVector9 == null) {
            return Double.NEGATIVE_INFINITY;
        }
        for (int i = 0; i < this.fieldLength; ++i) {
            denseVector2.set(i, dArray[i] * Math.exp(-denseVector9.get(i)));
            denseVector3.set(i, denseVector9.get(i) + 1.0);
            upperSPDBandMatrix2.set(i, i, denseVector2.get(i) + upperSPDBandMatrix2.get(i, i));
            denseVector2.set(i, denseVector2.get(i) * denseVector3.get(i) - 1.0);
        }
        bandCholesky2.factor(upperSPDBandMatrix2.copy());
        DenseVector denseVector10 = this.getMultiNormalMean(denseVector2, bandCholesky2);
        for (int i = 0; i < this.fieldLength; ++i) {
            denseVector2.set(i, denseVector.get(i) - denseVector10.get(i));
        }
        upperSPDBandMatrix2.mult(denseVector2, denseVector4);
        d5 += GMRFSkyrideBlockUpdateOperator.logGeneralizedDeterminant(bandCholesky2.getU()) - 0.5 * denseVector2.dot(denseVector4);
        return d5 -= GMRFSkyrideBlockUpdateOperator.logGeneralizedDeterminant(bandCholesky.getU()) - 0.5 * denseVector7.dot(denseVector7);
    }

    @Override
    public final String getOperatorName() {
        return "gmrfBlockUpdateOperator";
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.sqrt(this.scaleFactor - 1.0);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.scaleFactor = 1.0 + d * d;
    }

    @Override
    public double getRawParameter() {
        return this.scaleFactor;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public String getAdaptableParameterName() {
        return "scaleFactor";
    }
}

