/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.tree.MicrosatelliteSamplerTreeModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Parameter;
import dr.inference.operators.RandomWalkIntegerOperator;
import dr.math.MathUtils;

public class RandomWalkIntegerSetSizeWeightedOperator
extends RandomWalkIntegerOperator {
    private MicrosatelliteSamplerTreeModel msatSampleTreeModel;
    private double[] weights;
    private double baseSetSize;

    public RandomWalkIntegerSetSizeWeightedOperator(Parameter parameter, int n, double d, MicrosatelliteSamplerTreeModel microsatelliteSamplerTreeModel, double d2) {
        super(parameter, n, d);
        this.msatSampleTreeModel = microsatelliteSamplerTreeModel;
        this.baseSetSize = d2;
    }

    private void computeSampleWeights() {
        TreeModel treeModel = this.msatSampleTreeModel.getTreeModel();
        int n = treeModel.getInternalNodeCount();
        int n2 = treeModel.getExternalNodeCount();
        this.weights = new double[n];
        for (int i = 0; i < n; ++i) {
            NodeRef nodeRef = treeModel.getNode(i + n2);
            int n3 = this.msatSampleTreeModel.getNodeValue(treeModel.getChild(nodeRef, 0));
            int n4 = this.msatSampleTreeModel.getNodeValue(treeModel.getChild(nodeRef, 1));
            this.weights[i] = (double)Math.abs(n3 - n4) + this.baseSetSize;
        }
    }

    @Override
    public double doOperation() {
        this.computeSampleWeights();
        int n = MathUtils.randomChoicePDF(this.weights);
        int n2 = this.calculateNewValue(n);
        this.parameter.setValue(n, n2);
        return 0.0;
    }

    @Override
    public String getOperatorName() {
        return "randomWalkIntegerSetSizeWeighted(" + this.parameter.getId() + ")";
    }

    @Override
    public double getTargetAcceptanceProbability() {
        return 0.234;
    }

    @Override
    public double getMinimumAcceptanceLevel() {
        return 0.1;
    }

    @Override
    public double getMaximumAcceptanceLevel() {
        return 0.4;
    }

    @Override
    public double getMinimumGoodAcceptanceLevel() {
        return 0.2;
    }

    @Override
    public double getMaximumGoodAcceptanceLevel() {
        return 0.3;
    }

    @Override
    public String toString() {
        return "randomWalkIntegerNodeHeightWeightedOperator(" + this.parameter.getId() + ", " + this.windowSize + ", " + this.getWeight() + ")";
    }
}

