/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.distributions.GammaDistribution;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class GibbsIndependentGammaOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    public static final String OPERATOR_NAME = "GibbsIndependentGammaOperator";
    public static final String SHAPE = "shape";
    public static final String SCALE = "scale";
    private Variable<Double> variable = null;
    private GammaDistribution gamma = null;
    private boolean updateAllIndependently = true;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), AttributeRule.newDoubleRule("shape"), AttributeRule.newDoubleRule("scale"), new ElementRule(Parameter.class)};

        @Override
        public String getParserName() {
            return GibbsIndependentGammaOperator.OPERATOR_NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            double d2 = xMLObject.getDoubleAttribute(GibbsIndependentGammaOperator.SHAPE);
            double d3 = xMLObject.getDoubleAttribute(GibbsIndependentGammaOperator.SCALE);
            if (!(d2 > 0.0) || !(d3 > 0.0)) {
                throw new XMLParseException("Shape and scale must be positive values.");
            }
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            return new GibbsIndependentGammaOperator(parameter, new GammaDistribution(d2, d3), d);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "This element returns an independence sampler, disguised as a Gibbs operator, from a provided gamma prior.";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }
    };

    public GibbsIndependentGammaOperator(Variable variable, GammaDistribution gammaDistribution) {
        this(variable, gammaDistribution, 1.0);
    }

    public GibbsIndependentGammaOperator(Variable variable, GammaDistribution gammaDistribution, double d) {
        this(variable, gammaDistribution, d, true);
    }

    public GibbsIndependentGammaOperator(Variable variable, GammaDistribution gammaDistribution, double d, boolean bl) {
        this.variable = variable;
        this.gamma = gammaDistribution;
        this.updateAllIndependently = bl;
        this.setWeight(d);
    }

    @Override
    public void setPathParameter(double d) {
    }

    public String getPerformanceSuggestion() {
        return "";
    }

    @Override
    public String getOperatorName() {
        return "GibbsIndependentGamma(" + this.variable.getVariableName() + ")";
    }

    public int getStepCount() {
        return 1;
    }

    @Override
    public double doOperation() {
        Bounds<Double> bounds = this.variable.getBounds();
        int n = this.variable.getSize();
        if (this.updateAllIndependently) {
            for (int i = 0; i < n; ++i) {
                double d = this.gamma.nextGamma();
                while (d == 0.0) {
                    d = this.gamma.nextGamma();
                }
                if (d < bounds.getLowerLimit(i) || d > bounds.getUpperLimit(i)) {
                    throw new RuntimeException("proposed value outside boundaries");
                }
                this.variable.setValue(i, d);
            }
        }
        return 0.0;
    }
}

