/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.distribution.MultivariateDistributionLikelihood;
import dr.inference.distribution.MultivariateNormalDistributionModel;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.Vector;
import dr.util.Attribute;
import java.util.List;

public class MultivariateNormalGibbsOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    private Matrix priorPrecision;
    private Vector priorMean;
    private MatrixParameter likelihoodPrecision;
    private Parameter likelihoodMean;
    private MultivariateDistributionLikelihood likelihood;
    private int dim;
    public static final String MVN_GIBBS = "multivariateNormalGibbsOperator";

    public MultivariateNormalGibbsOperator(MultivariateDistributionLikelihood multivariateDistributionLikelihood, MultivariateDistributionLikelihood multivariateDistributionLikelihood2, Double d) throws IllegalDimension {
        MultivariateNormalDistribution multivariateNormalDistribution = (MultivariateNormalDistribution)multivariateDistributionLikelihood2.getDistribution();
        this.priorMean = new Vector(multivariateNormalDistribution.getMean());
        this.priorPrecision = new Matrix(multivariateNormalDistribution.getScaleMatrix());
        MultivariateNormalDistributionModel multivariateNormalDistributionModel = (MultivariateNormalDistributionModel)multivariateDistributionLikelihood.getDistribution();
        this.likelihoodMean = multivariateNormalDistributionModel.getMeanParameter();
        this.likelihoodPrecision = multivariateNormalDistributionModel.getPrecisionMatrixParameter();
        this.likelihood = multivariateDistributionLikelihood;
        this.dim = ((Double[])this.likelihoodMean.getValues()).length;
        this.setWeight(d);
    }

    private void setParameterValue(Parameter parameter, double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            parameter.setParameterValueQuietly(i, dArray[i]);
        }
        parameter.fireParameterChangedEvent();
    }

    private double[] getMeanSum() {
        double[] dArray = new double[this.dim];
        List<Attribute<double[]>> list = this.likelihood.getDataList();
        for (Attribute<double[]> attribute : list) {
            for (int i = 0; i < attribute.getAttributeValue().length; ++i) {
                int n = i;
                dArray[n] = dArray[n] + attribute.getAttributeValue()[i];
            }
        }
        return dArray;
    }

    private Matrix getPrecision() throws IllegalDimension {
        Matrix matrix = new Matrix(this.likelihoodPrecision.getParameterAsMatrix());
        matrix = matrix.product(this.likelihood.getDataList().size());
        return this.priorPrecision.add(matrix);
    }

    private Vector getMean() throws IllegalDimension {
        Vector vector = new Vector(this.getMeanSum());
        Matrix matrix = new Matrix(this.likelihoodPrecision.getParameterAsMatrix());
        Vector vector2 = matrix.product(vector);
        vector2 = vector2.add(this.priorPrecision.product(this.priorMean));
        Matrix matrix2 = this.getPrecision().inverse();
        Vector vector3 = matrix2.product(vector2);
        return vector3;
    }

    @Override
    public String getOperatorName() {
        return MVN_GIBBS;
    }

    @Override
    public double doOperation() {
        double[] dArray = null;
        try {
            dArray = MultivariateNormalDistribution.nextMultivariateNormalPrecision(this.getMean().toComponents(), this.getPrecision().toComponents());
        }
        catch (IllegalDimension illegalDimension) {
            illegalDimension.printStackTrace();
        }
        this.setParameterValue(this.likelihoodMean, dArray);
        return 0.0;
    }
}

