/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.BoundedSpace;
import dr.inference.model.Parameter;
import dr.inference.model.TransformedParameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.SimpleMCMCOperator;

public class TransformedParameterOperator
extends AbstractAdaptableOperator {
    private final boolean isAdaptable;
    private final SimpleMCMCOperator subOperator;
    private final TransformedParameter parameter;
    private final boolean checkValid;
    private final BoundedSpace generalBounds;
    public static final String TRANSFORMED_OPERATOR = "transformedParameterOperator";

    public TransformedParameterOperator(SimpleMCMCOperator simpleMCMCOperator, BoundedSpace boundedSpace) {
        this.subOperator = simpleMCMCOperator;
        this.setWeight(simpleMCMCOperator.getWeight());
        this.isAdaptable = simpleMCMCOperator instanceof AbstractAdaptableOperator;
        this.parameter = (TransformedParameter)simpleMCMCOperator.getParameter();
        this.generalBounds = boundedSpace;
        this.checkValid = boundedSpace != null;
    }

    @Override
    protected void setAdaptableParameterValue(double d) {
        if (this.isAdaptable) {
            ((AbstractAdaptableOperator)this.subOperator).setAdaptableParameterValue(d);
        }
    }

    @Override
    protected double getAdaptableParameterValue() {
        if (this.isAdaptable) {
            return ((AbstractAdaptableOperator)this.subOperator).getAdaptableParameterValue();
        }
        return 0.0;
    }

    @Override
    public double getRawParameter() {
        if (this.isAdaptable) {
            return ((AbstractAdaptableOperator)this.subOperator).getRawParameter();
        }
        throw new RuntimeException("not actually adaptable parameter");
    }

    @Override
    public String getAdaptableParameterName() {
        if (this.isAdaptable) {
            return ((AbstractAdaptableOperator)this.subOperator).getAdaptableParameterName();
        }
        throw new RuntimeException("not actually adaptable parameter");
    }

    @Override
    public String getOperatorName() {
        return "transformedParameterOperator." + this.subOperator.getOperatorName();
    }

    @Override
    public double doOperation() {
        double[] dArray = this.parameter.getParameterUntransformedValues();
        double d = this.subOperator.doOperation();
        double[] dArray2 = this.parameter.getParameterUntransformedValues();
        if (this.checkValid) {
            if (this.generalBounds == null && !this.parameter.isWithinBounds()) {
                return Double.NEGATIVE_INFINITY;
            }
            if (!this.generalBounds.isWithinBounds(this.parameter.getParameterValues())) {
                return Double.NEGATIVE_INFINITY;
            }
        }
        return d += this.parameter.diffLogJacobian(dArray, dArray2);
    }

    @Override
    public Parameter getParameter() {
        return this.subOperator.getParameter();
    }
}

