% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbabilityFunctions.R
\name{sim_Zn_stat}
\alias{sim_Zn_stat}
\title{Rènyi-Type Statistic Simulation}
\usage{
sim_Zn_stat(size, kn = function(n) {     floor(sqrt(n)) },
  use_kernel_var = FALSE, kernel = "ba", bandwidth = "and",
  n = 500, gen_func = rnorm, args = NULL, parallel = FALSE)
}
\arguments{
\item{size}{Number of realizations to simulate}

\item{kn}{A function returning a positive integer that is used in the
definition of the Rènyi-type statistic effectively setting the
bounds over which the maximum is taken}

\item{use_kernel_var}{Set to \code{TRUE} to use kernel-based long-run
variance estimation (\code{FALSE} means this is not
employed)}

\item{kernel}{If character, the identifier of the kernel function as used in
the \pkg{cointReg} (see documentation for
\code{cointReg::getLongRunVar}); if function, the kernel
function to be used for long-run variance estimation (default
is the Bartlett kernel in \pkg{cointReg}); this parameter
has no effect if \code{use_kernel_var} is \code{FALSE}}

\item{bandwidth}{If character, the identifier of how to compute the bandwidth
as defined in the \pkg{cointReg} package (see
documentation for \code{cointReg::getLongRunVar}); if
function, a function to use for computing the bandwidth; if
numeric, the bandwidth to use (the default behavior is to
use the \insertCite{andrews91b;textual}{CPAT} method, as
used in \pkg{cointReg}); this parameter has no effect if
\code{use_kernel_var} is \code{FALSE}}

\item{n}{The sample size for each realization}

\item{gen_func}{The function generating the random sample from which the
statistic is computed}

\item{args}{A list of arguments to be passed to \code{gen_func}}

\item{parallel}{Whether to use the \pkg{foreach} and \pkg{doParallel}
packages to parallelize simulation (which needs to be
initialized in the global namespace before use)}
}
\value{
A vector of simulated realizations of the Rènyi-type statistic
}
\description{
Simulates multiple realizations of the Rènyi-type statistic.
}
\details{
This differs from \code{sim_Zn()} in that the long-run variance is estimated
with this function, while \code{sim_Zn()} assumes the long-run variance is
known. Estimation can be done in a variety of ways. If \code{use_kernel_var}
is set to \code{TRUE}, long-run variance estimation using kernel-based
techniques will be employed; otherwise, a technique resembling standard
variance estimation will be employed. Any technique employed, though, will
account for the potential break points, as described in
\insertCite{horvathricemiller19;textual}{CPAT}. See the documentation for
\code{\link{stat_Zn}} for more details.

The parameters \code{kernel} and \code{bandwidth} control parameters for
long-run variance estimation using kernel methods. These parameters will be
passed directly to \code{\link{stat_Zn}}.
}
\examples{
CPAT:::sim_Zn_stat(100)
CPAT:::sim_Zn_stat(100, kn = function(n) {floor(log(n))},
            use_kernel_var = TRUE, gen_func = CPAT:::rchangepoint,
            args = list(changepoint = 250, mean2 = 1))
}
\references{
\insertAllCited{}
}
