library(CRF)

test.decode <- function(name, decode.method, dataset, ...)
{
  crf <- dataset$crf
  answer <- dataset$answer

  cat("  ", name, ": Decoding ... ", sep="")

  if (identical(decode.method, decode.ilp) && !requireNamespace("Rglpk", quietly = TRUE)) {
    cat("Skipped.\n")
  }
  else {
    decode <- decode.method(crf, ...)
    
    if (all(decode == answer$decode)) {
      cat("Passed.\n")
    } else {
      cat("Failed ***\n")
      warning(name, ": Decoding is incorrect!")
    }
  }
}

cat("Testing dataset Small ...\n")
data(Small)
test.decode("Exact", decode.exact, Small)
test.decode("Chain", decode.chain, Small)
test.decode("Tree", decode.tree, Small)
test.decode("Cutset", decode.cutset, Small, c(3))
test.decode("Cutset (Chain)", decode.cutset, Small, c(1), "chain")
test.decode("JunctionTree", decode.junction, Small)
test.decode("Sample", decode.sample, Small, sample.exact, 10000)
test.decode("LBP", decode.lbp, Small)
test.decode("RBP", decode.rbp, Small)
test.decode("TRBP", decode.trbp, Small)
test.decode("Greedy", decode.greedy, Small)
test.decode("Greedy (Restart)", decode.greedy, Small, restart = 100)
test.decode("ICM", decode.icm, Small)
test.decode("ICM (Restart)", decode.icm, Small, restart = 100)
test.decode("Block", decode.block, Small, blocks = list(1:2, 3:4))
test.decode("Block (Restart)", decode.block, Small, blocks = list(1:2, 3:4), restart = 100)
test.decode("ILP", decode.ilp, Small)
test.decode("ILP (LP Rounding)", decode.ilp, Small, lp.rounding = TRUE)

cat("Testing dataset Chain ...\n")
data(Chain)
test.decode("Chain", decode.chain, Chain)
test.decode("Tree", decode.tree, Chain)
test.decode("Cutset", decode.cutset, Chain, c(3))
test.decode("Cutset (Chain)", decode.cutset, Chain, c(1), "chain")
test.decode("JunctionTree", decode.junction, Chain)
test.decode("Sample", decode.sample, Chain, sample.chain, 10000)
test.decode("LBP", decode.lbp, Chain)
test.decode("RBP", decode.rbp, Chain)
test.decode("TRBP", decode.trbp, Chain)
test.decode("Greedy", decode.greedy, Chain)
test.decode("Greedy (Restart)", decode.greedy, Chain, restart = 100)
test.decode("ICM", decode.icm, Chain)
test.decode("ICM (Restart)", decode.icm, Chain, restart = 100)
test.decode("Block", decode.block, Chain, blocks = list(1:30, 31:60))
test.decode("Block (Restart)", decode.block, Chain, blocks = list(1:30, 31:60), restart = 100)
test.decode("ILP", decode.ilp, Chain)
test.decode("ILP (LP Rounding)", decode.ilp, Chain, lp.rounding = TRUE)

cat("Testing dataset Tree ...\n")
data(Tree)
test.decode("Tree", decode.tree, Tree)
test.decode("Cutset", decode.cutset, Tree, c(3))
test.decode("JunctionTree", decode.junction, Tree)
test.decode("Sample", decode.sample, Tree, sample.tree, 10000)
test.decode("LBP", decode.lbp, Tree)
test.decode("RBP", decode.rbp, Tree)
test.decode("TRBP", decode.trbp, Tree)
test.decode("Greedy", decode.greedy, Tree)
test.decode("Greedy (Restart)", decode.greedy, Tree, restart = 100)
test.decode("ICM", decode.icm, Tree)
test.decode("ICM (Restart)", decode.icm, Tree, restart = 100)
test.decode("Block", decode.block, Tree, blocks = list(1:30, 31:60, 61:100))
test.decode("Block (Restart)", decode.block, Tree, blocks = list(1:30, 31:60, 61:100), restart = 100)
test.decode("ILP", decode.ilp, Tree)
test.decode("ILP (LP Rounding)", decode.ilp, Tree, lp.rounding = TRUE)

cat("Testing dataset Loop ...\n")
data(Loop)
test.decode("Cutset", decode.cutset, Loop, c(3))
test.decode("Cutset (Chain)", decode.cutset, Loop, c(1), "chain")
test.decode("JunctionTree", decode.junction, Loop)
test.decode("Sample", decode.sample, Loop, sample.exact, 10000)
test.decode("LBP", decode.lbp, Loop)
test.decode("RBP", decode.rbp, Loop)
test.decode("TRBP", decode.trbp, Loop)
test.decode("Greedy", decode.greedy, Loop)
test.decode("Greedy (Restart)", decode.greedy, Loop, restart = 100)
test.decode("ICM", decode.icm, Loop)
test.decode("ICM (Restart)", decode.icm, Loop, restart = 100)
test.decode("Block", decode.block, Loop, blocks = list(1:2, 3:4))
test.decode("Block (Restart)", decode.block, Loop, blocks = list(1:2, 3:4), restart = 100)
test.decode("ILP", decode.ilp, Loop)
test.decode("ILP (LP Rounding)", decode.ilp, Loop, lp.rounding = TRUE)

cat("Testing dataset Clique ...\n")
data(Clique)
test.decode("Cutset", decode.cutset, Clique, c(1,3))
test.decode("JunctionTree", decode.junction, Clique)
test.decode("Sample", decode.sample, Clique, sample.exact, 10000)
test.decode("LBP", decode.lbp, Clique)
test.decode("RBP", decode.rbp, Clique)
test.decode("TRBP", decode.trbp, Clique)
test.decode("Greedy", decode.greedy, Clique, c(1,1,1,2))
test.decode("Greedy (Restart)", decode.greedy, Clique, restart = 100)
test.decode("ICM", decode.icm, Clique, start = c(2,1,1,1))
test.decode("ICM (Restart)", decode.icm, Clique, restart = 100)
test.decode("Block", decode.block, Clique, blocks = list(c(1,3), c(2,4)))
test.decode("Block (Restart)", decode.block, Clique, blocks = list(c(1,3), c(2,4)), restart = 100)
test.decode("ILP", decode.ilp, Clique)
test.decode("ILP (LP Rounding)", decode.ilp, Clique, lp.rounding = TRUE)
