% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dosing.r
\name{addDoseCycle}
\alias{addDoseCycle}
\title{Adds a dosing cycle to model}
\usage{
addDoseCycle(
  .Object,
  type = "SteadyState",
  name,
  administration = "Bolus",
  amount = NULL,
  II = NULL,
  rate = NULL,
  duration = NULL,
  isSecondDose = FALSE,
  colName = NULL
)
}
\arguments{
\item{.Object}{Model object}

\item{type}{Specification of dose type. Options are \code{"SteadyState"}and \code{"ADDL"}}

\item{name}{Dose point name. See \code{\link{doseNames}}}

\item{administration}{Mechanism for administering dose. Options are \code{"Bolus"} or \code{"Infusion"}}

\item{amount}{Optional. Column mapping argument specifying corresponding "ADDL" column in input data, or
numeric value specifiying dose amount.}

\item{II}{Optional. Column mapping argument specifying corresponding "II" column in input data, or
numeric value specifying delta time.}

\item{rate}{Optional. Column mapping argument specifying corresponding "Rate" column in input data,
or numeric specifying dose rate.}

\item{duration}{Optional. Column mapping argument specifying corresponding "Duration" column in data,
or numeric specifying duration value.}

\item{isSecondDose}{Use second dose point on compartment}

\item{colName}{Column name in input data corresponding to column mapping for "SteadyState" or "ADDL" as supplied in \code{type} argument.}
}
\value{
Modified \code{NlmePmlModel} object
}
\description{
Add Steady State or ADDL dosing cycle to model object.
}
\examples{
\donttest{
model <- pkmodel(columnMap = FALSE) \%>\%
  addDoseCycle(type = "SteadyState", name = "A1", amount = "Amount", II = "II")
}

}
\seealso{
\code{\link{doseNames}}
}
