% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dosing.r
\name{addMDV}
\alias{addMDV}
\title{Adds MDV extra column definition to model object}
\usage{
addMDV(.Object, MDV)
}
\arguments{
\item{.Object}{Model object}

\item{MDV}{Column mapping argument specifying corresponding "MDV" column in input data set}
}
\value{
Modified \code{NlmePmlModel} object
}
\description{
Use to add MDV statement to \code{model@userDefinedExtraDefs}
}
\examples{
\donttest{
pkData1 <- pkData
pkData1$MDV <- 0
model <- pkmodel(data = pkData1,
                 ID = "Subject",
                 Time = "Act_Time",
                 A1 = "Amount",
                 CObs = "Conc",
                 workingDir = tempdir()
                 )
model <- addMDV(model, MDV = "MDV")
}
}
