% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess_JAR.R
\name{preprocess_JAR}
\alias{preprocess_JAR}
\title{Preprocessing for Just About Right Data}
\usage{
preprocess_JAR(Data,  nprod, nsub, levelsJAR=3, beta=0.1)
}
\arguments{
\item{Data}{data frame where the first column is the Assessors, the second is the products and all other columns the JAR attributes with numbers (1 to 3 or 1 to 5, see levelsJAR)}

\item{nprod}{integer. Number of products.}

\item{nsub}{integer. Number of subjects.}

\item{levelsJAR}{integer. 3 or 5 levels. If 5, the data will be transformed in 3 levels.}

\item{beta}{numerical. Parameter for agreement between JAR and other answers. Between 0 and 0.5.}
}
\value{
A list with:
        \itemize{
         \item Datafinal: the Data transformed
         \item NameSub: the name of each subject in the right order
         }
}
\description{
For JAR data, this preprocessing is needed.
}
\examples{
data(cheese)
prepro=preprocess_JAR(cheese, nprod=8, nsub=72, levelsJAR=5)

}
\references{
Llobell, F., Vigneau, E. & Qannari, E. M. (September 14, 2022). Multivariate data analysis and clustering of subjects in a Just about right task. Eurosense, Turku, Finland.
}
\seealso{
\code{\link{catatis_jar}}, \code{\link{cluscata_jar}}, \code{\link{cluscata_kmeans_jar}}
}
\keyword{JAR}
