% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimate_Param_EstParmFunc.R
\name{Estimate_Param_EstParmFunc}
\alias{Estimate_Param_EstParmFunc}
\title{Estimating Parameters of EstParmFunc}
\usage{
Estimate_Param_EstParmFunc(Iter.EstParmFunc, paramini, especie, seed = NULL)
}
\arguments{
\item{Iter.EstParmFunc}{Number. Number of iterations.}

\item{paramini}{Initial values of the parameters. Vector equal to \code{c(tau.ini, as.vector(pam.ini))} where:}

\item{especie}{Matrix that contains at row i the bacterial taxa of bacteria i at all time points. The bacteria placed in the last row of the matrix will be used as reference in the alr transformation.}

\item{seed}{Number. Set a seed. Default \code{seed=NULL}.

\itemize{
  \item pam.ini  Matrix. Each row has the parameters of each bacteria, following the same structure than pam in EstParmFunc
  \item tau.ini  Number. Initial value of the tau parameter in the model
  }}
}
\value{
Returns a list with:
\itemize{
  \item All.iter:  Matrix. Each row has the parameters obtained in each iteration. The parameters are in the columns written in the same order that they are written in \code{paramini}. In this matrix we must observe that in the last iterations the values has really similar or equal values, it not, we need to increase the value of \code{Iter.EstParmFunc}.
 \item Param.Estimates: The estimated parameters. The parameters are in the columns written in the same order that they are written in \code{paramini}.
  }
}
\description{
This function calculates the estimated parameters of the Dirich-gLV model.
}
\details{
Maximum likelihood estimation is used. This function makes an iterative process, it obtains the value of the parameter that maximize the Dirichlet loglikelihood (defined in EstParmFunc) using the Nelder-Mead method and some initial parameters. Then it uses this value as initial parameters and repeats the process \code{Iter.EstParmFunc} times.
}
\examples{

especie=cbind(c(0.5,0.3,0.2),c(0.1,0.3,0.6))
paramini=c(100,2,3,4,5,6,7)
Estimate_Param_EstParmFunc(5, paramini , especie,714)


}
\references{
Creus-Martí, I. and Moya, A. and Santonja, F. J. (2018). A Statistical Model with a Lotka-Volterra Structure for Microbiota Data. Lucas Jodar, Juan Carlos Cortes and Luis Acedo,  Modelling for engineering and human behavior 2018, Instituto Universitario de Matematica Multidisciplinar. ISBN: 978-84-09-07541-6
}
