% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MaxBacteria.R
\name{MaxBacteria}
\alias{MaxBacteria}
\title{Putting the reference bacteria at the last row}
\usage{
MaxBacteria(nombresOriginal, especieOriginal, E, Tt, which.esp)
}
\arguments{
\item{nombresOriginal}{Vector with the bacterial names at the same order than in DaTa. it must be fulfilled that lenght(nombresOriginal)==dim(DaTa)[2]-1}

\item{especieOriginal}{Matrix that contains at row i the bacterial taxa of bacteria i at all time points}

\item{E}{Number of bacteria available}

\item{Tt}{Number of bacteria available}

\item{which.esp}{If \code{which=="Max"} this function puts in the last position of the matrix the bacteria with maximum mean abundance.  If \code{which=="Min"} this function puts in the last position of the matrix the bacteria with minimum mean abundance.  If which is equal to a number this function puts in the last position of the matrix the bacteria that is in the "which" row of the \code{especieOriginal} matrix.}
}
\value{
Returns a list with
\itemize{
  \item \code{especie} - Matrix that contains at row i the bacterial taxa of bacteria i at all time points but  the bacteria with maximum (or minimum) mean abundance (or the bacteria indicated by the user) is placed at the last row.
  \item \code{especiemodi} - Matrix that contains at row i the bacterial taxa of bacteria i at time points t=2,...,\code{Tt} but  the bacteria with maximum (or minimum) mean abundance (or the bacteria indicated by the user) is placed at the last row.
   \item \code{nombres} - Vector with the bacteria's names placed in the order in which appear in the rows of the matrices \code{especie} and \code{especiemodi}
  \item \code{EE}  - Row in which the bacterial with maximum (or minimum) mean abundance was (or the value of "which" if which is numerical).
   \item  \code{EspecieMaxima} - Row in which the bacterial with maximum (or minimum) mean abundance (or the bacteria indicated by the user) is in \code{especie}.)
#' }
}
\description{
This function calculates the mean abundance of each bacteria. Then, it creates a matrix where each row contains the abundance of one bacteria at all time points but  the bacteria with maximum (or minimum or a bacteria indicated by the user) mean abundance is placed at the last row
}
\examples{

names1=c("Bact1","Bact2","Bact3")
set.seed(314)
esp1=t(gtools::rdirichlet(n=4, c(1,3,1)))
e1=3
t1=4

MaxBacteria(names1,esp1,e1,t1,"Max")


names3=c("Bact1","Bact2","Bact3","Bact4","Bact5")
set.seed(314)
esp3=t(gtools::rdirichlet(n=6, c(6,6,1,6,6)))
e3=5
t3=6
MaxBacteria(names3,esp3,e3,t3,"Min")


}
