% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bland_Altman.R
\name{Bland_Altman}
\alias{Bland_Altman}
\title{Bland & Altman plot}
\usage{
Bland_Altman(proportions, additional_info_shape = NULL)
}
\arguments{
\item{proportions}{\code{data.frame} of true and estimated proportion returned from \code{\link{CytOpT}()}.}

\item{additional_info_shape}{vector of additional information to be used for shape in the plot. Not implemented yet.

#'@return a \code{\link[ggplot2]{ggplot}} object}
}
\description{
Function to display a Bland & Altman plot in order to visually assess the agreement between CytOpt estimation
of the class proportions and the estimate of the class proportions provided through manual gating. 
Requires that either \code{theta_true} or \code{Lab_target} was provided when running \code{\link{CytOpT}()}.
}
\examples{
if(interactive()){

gold_standard_manual_prop <- c(table(HIPC_Stanford_1369_1A_labels) /
 length(HIPC_Stanford_1369_1A_labels))
res <- CytOpT(X_s = HIPC_Stanford_1228_1A, X_t = HIPC_Stanford_1369_1A, 
             Lab_source = HIPC_Stanford_1228_1A_labels,
             theta_true = gold_standard_manual_prop,
             eps = 0.0001, lbd = 0.0001, n_iter = 10000, n_stoc=10,
             step_grad = 10, step = 5, power = 0.99, 
             method='both')
Bland_Altman(res$proportions)

}
}
\seealso{
\code{\link{CytOpT}}
}
